/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.design.copy;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.model.providers.design.DesignPlugin;
import com.tssap.selena.model.providers.design.copy.CompositeCopyExtender;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtender;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtenderFactory;
import com.tssap.selena.model.providers.design.copy.PropertyCopyExtender;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultCopyExtenderFactory
implements IDesignCopyExtenderFactory,
IExecutableExtension {
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_PROPERTY_NAME = "name";
    private HashSet myPropertyNames = new HashSet();

    public void setInitializationData(IConfigurationElement config, String clazzProperty, Object data) throws CoreException {
        IConfigurationElement[] children = config.getChildren(TAG_PROPERTY);
        int i = 0;
        while (i < children.length) {
            IConfigurationElement next = children[i];
            String propertyName = next.getAttribute(ATTR_PROPERTY_NAME);
            if (propertyName != null) {
                this.assertTrue("Duplicate propertyName: " + propertyName + " is registered for DefaultCopyExtenderFactory", !this.myPropertyNames.contains(propertyName));
                this.myPropertyNames.add(propertyName);
            }
            ++i;
        }
        this.assertTrue("At least one propertyName should be registered for DefaultCopyExtenderFactory", !this.myPropertyNames.isEmpty());
    }

    public IDesignCopyExtender createExtender(DesignElement designElement) {
        if (this.myPropertyNames.size() == 1) {
            return new PropertyCopyExtender((String)this.myPropertyNames.iterator().next());
        }
        CompositeCopyExtender result = new CompositeCopyExtender();
        Iterator properties = this.myPropertyNames.iterator();
        while (properties.hasNext()) {
            String nextName = (String)properties.next();
            result.addExtender(new PropertyCopyExtender(nextName));
        }
        return result;
    }

    private void assertTrue(String message, boolean tested) throws CoreException {
        if (!tested) {
            throw new CoreException((IStatus)new Status(4, DesignPlugin.PLUGIN_ID, 0, message, null));
        }
    }
}

