/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.ui.wizards;

import com.sap.ide.jcb.core.service.IR3Service;
import com.sap.ide.jcb.core.service.connection.ConnectionFailedException;
import com.sap.ide.jcb.core.service.generation.GenerationException;
import com.sap.ide.jcb.core.service.generation.GenerationTargetChangedEvent;
import com.sap.ide.jcb.core.service.generation.GenerationTargetChangedListener;
import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.jcb.core.service.generation.IGenerationManager;
import com.sap.ide.jcb.core.service.internal.R3Service;
import com.sap.ide.jcb.core.util.ResourceHelper;
import com.sap.ide.jcb.core.wizardpages.RFCSelectionPage;
import com.sap.ide.jcb.core.wizardpages.SAPLogonPage;
import com.sap.ide.jcb.ui.LogHandler;
import com.sap.ide.jcb.ui.SAPJavaConnectivityBuilderUIPlugin;
import com.sap.ide.jcb.ui.TextPool;
import com.sap.ide.jcb.ui.wizards.RFCClassDetailsPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class RfcImportWizard
extends Wizard
implements INewWizard,
IImportWizard {
    private static final String RFC_IMPORT_WIZARD_SECTION = "RFC Import Wizard";
    private static final TextPool mTPool = TextPool.getInstance();
    private IWorkbench mWorkbench = PlatformUI.getWorkbench();
    private IR3Service mR3Service;
    private IGenerationData mGenerationData;
    private RFCClassDetailsPage mRFCClassDetailsPage;
    private SAPLogonPage mSAPLogonPage;
    private RFCSelectionPage mRFCSelectionPage;
    private GenerationException mGenerationException;

    public RfcImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.mRFCClassDetailsPage = new RFCClassDetailsPage();
        this.mSAPLogonPage = new SAPLogonPage();
        this.mRFCSelectionPage = new RFCSelectionPage();
        this.mRFCClassDetailsPage.setImageDescriptor(SAPJavaConnectivityBuilderUIPlugin.createImageDescriptor("resources\\icons\\wzBannerRfcConnection.gif"));
        this.mSAPLogonPage.setImageDescriptor(SAPJavaConnectivityBuilderUIPlugin.createImageDescriptor("resources\\icons\\wzBannerRfcConnection.gif"));
        this.mRFCSelectionPage.setImageDescriptor(SAPJavaConnectivityBuilderUIPlugin.createImageDescriptor("resources\\icons\\wzBannerRfcConnection.gif"));
        this.addGenerationTargetChangedListener();
        this.mR3Service = R3Service.getInstance();
        this.mSAPLogonPage.setConnectionManager(this.mR3Service.getConnectionManager());
        this.mRFCSelectionPage.setR3Service(this.mR3Service);
        this.setWindowTitle(mTPool.getText(1));
        this.setUpDialogSection();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mWorkbench = workbench;
        this.mRFCClassDetailsPage.init(selection);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mRFCClassDetailsPage);
        this.addPage((IWizardPage)this.mSAPLogonPage);
        this.addPage((IWizardPage)this.mRFCSelectionPage);
    }

    public boolean performFinish() {
        try {
            this.mRFCClassDetailsPage.performFinish();
            this.mSAPLogonPage.performFinish();
            this.mRFCSelectionPage.performFinish();
            return this.generateProxy();
        }
        catch (ConnectionFailedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Login Failed", (String)e.getMessage());
            LogHandler.logException(e);
            return false;
        }
    }

    private boolean generateProxy() {
        this.mGenerationException = null;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                IGenerationManager generationManager = RfcImportWizard.this.mR3Service.getGenerationManagerFactory().getGenerationManager(RfcImportWizard.this.mGenerationData);
                if (generationManager != null) {
                    RfcImportWizard.this.saveMemento(generationManager);
                    generationManager.setConnectionManager(RfcImportWizard.this.mR3Service.getConnectionManager());
                    generationManager.setWorkingSet(RfcImportWizard.this.mR3Service.getWorkingSet());
                    try {
                        RfcImportWizard.this.getContainer().run(true, false, generationManager.getRunnable());
                        ResourceHelper.openResource((IResource)generationManager.getGeneratedResource(), (IWorkbench)RfcImportWizard.this.mWorkbench, (Display)RfcImportWizard.this.getShell().getDisplay());
                    }
                    catch (InvocationTargetException e) {
                        LogHandler.logException(e);
                        if (e.getTargetException() instanceof GenerationException) {
                            RfcImportWizard.this.mGenerationException = (GenerationException)e.getTargetException();
                        }
                    }
                    catch (InterruptedException e) {
                        LogHandler.logException(e);
                    }
                }
            }
        });
        if (this.mGenerationException != null) {
            MessageDialog.openError(null, (String)mTPool.getText(2), (String)this.mGenerationException.getMessage());
            return true;
        }
        return true;
    }

    private void setUpDialogSection() {
        IDialogSettings theDialogSettings = SAPJavaConnectivityBuilderUIPlugin.getDefault().getDialogSettings();
        IDialogSettings theSection = theDialogSettings.getSection(RFC_IMPORT_WIZARD_SECTION);
        if (theSection == null) {
            theSection = theDialogSettings.addNewSection(RFC_IMPORT_WIZARD_SECTION);
        }
        this.setDialogSettings(theSection);
    }

    private void saveMemento(IGenerationManager generationManager) {
        IMemento memento = generationManager.createMemento();
        if (memento != null) {
            this.mRFCClassDetailsPage.saveState(memento);
            this.mSAPLogonPage.saveState(memento);
            this.mRFCSelectionPage.saveState(memento);
        }
    }

    private void addGenerationTargetChangedListener() {
        this.mRFCClassDetailsPage.addGenerationTargetChangedListener(new GenerationTargetChangedListener(){

            public void generationTargetChanged(GenerationTargetChangedEvent generationTargetChangedEvent) {
                RfcImportWizard.this.handleGenerationTargetChanged(generationTargetChangedEvent.getGenerationData());
            }
        });
    }

    private void handleGenerationTargetChanged(IGenerationData generationData) {
        IMemento memento;
        this.mGenerationData = generationData;
        IGenerationManager generationManager = this.mR3Service.getGenerationManagerFactory().getGenerationManager(this.mGenerationData);
        if (generationManager != null && (memento = generationManager.getMemento()) != null) {
            this.mRFCClassDetailsPage.init(memento);
            this.mSAPLogonPage.init(memento);
            this.mRFCSelectionPage.init(memento);
        }
    }
}

