/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.jcb.ui.wizards;

import com.sap.ide.jcb.core.service.generation.GenerationTargetChangedEvent;
import com.sap.ide.jcb.core.service.generation.GenerationTargetChangedListener;
import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.jcb.core.service.generation.IGenerationManager;
import com.sap.ide.jcb.core.service.generation.IJarGenerationData;
import com.sap.ide.jcb.core.service.generation.ISourceGenerationData;
import com.sap.ide.jcb.core.service.generation.internal.JarGenerationData;
import com.sap.ide.jcb.core.service.generation.internal.SourceGenerationData;
import com.sap.ide.jcb.core.service.internal.R3Service;
import com.sap.ide.jcb.core.util.Status;
import com.sap.ide.jcb.ui.SAPJavaConnectivityBuilderUIPlugin;
import com.sap.ide.jcb.ui.TextPool;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class RFCClassDetailsPage
extends NewTypeWizardPage
implements Listener {
    private static final String CLASS_TAG = "Class";
    private static final String CLASS_NAME_ATTRIBUTE = "name";
    private static final String CLASS_PACKAGE_ATTRIBUTE = "package";
    private static final String CLASS_J2EE_ATTRIBUTE = "j2ee";
    private static final String GENERATION_TARGET_TAG = "GenerationTarget";
    private static final String GENERATION_TARGET_TYPE_ATTRIBUTE = "type";
    private static final String GENERATION_TARGET_OVERWRITE_ATTRIBUTE = "overwrite";
    private static final String GENERATION_TARGET_COMPILE_ATTRIBUTE = "compile";
    private static final String GENERATION_TARGET_SOURCE = "Source";
    private static final String GENERATION_TARGET_JAR = "Jar";
    public static final String JAR_EXTENSION = "jar";
    public static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private static final String CLASS_DETAILS_SECTION = "Class Details Section";
    private static final String SELECTED_GENERATION_TARGET_TYPE = "Selected Generation Target Type";
    private static final String SELECTED_GENERATION_TARGET_PATH = "Selected Generation Target Path";
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGE_NAME;
    private static final String PAGE_TITLE;
    private static final String PAGE_DESCRIPTION;
    private static final String JAR_PATH = "JarPath";
    private Text mClass;
    private Text mJarPath;
    private Text mSourcePath;
    private Button mJarBrowse;
    private Button mSourceBrowse;
    private Button mJarSelect;
    private Button mSourceSelect;
    private Button mOverwrite;
    private Button mCompileAfterGeneration;
    private Button mExportClassesOnly;
    private IGenerationData mGenerationData;
    private IJarGenerationData mJarGenerationData = new JarGenerationData();
    private ISourceGenerationData mSourceGenerationData = new SourceGenerationData();
    private boolean mGenerationTargetChanged = false;
    private boolean mJarGenerationPathDirty = false;
    private boolean mSourceGenerationPathDirty = false;
    private Status mJarGenerationTargetStatus = new Status(SAPJavaConnectivityBuilderUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, PAGE_DESCRIPTION);
    private IStatus mSourceGenerationTargetStatus = new Status(SAPJavaConnectivityBuilderUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, PAGE_DESCRIPTION);
    private boolean mJarPathDirty = false;
    private ArrayList mCreatedGenerationTargets = new ArrayList(1);
    private String mInitialSourcePath = "";
    private boolean mCanbeModified = false;
    private String mInitialClass = "";
    private boolean mInCreationMode = true;
    private ArrayList mGenerationTargetChangedListeners = new ArrayList();
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaModel;
    static /* synthetic */ Class class$com$sap$ide$jcb$core$service$generation$ISourceGenerationData;
    static /* synthetic */ Class class$com$sap$ide$jcb$core$service$generation$IJarGenerationData;

    public RFCClassDetailsPage() {
        super(true, PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = this.mJarSelect != null && this.mClass != null ? new IStatus[]{this.mJarSelect.getSelection() ? this.mJarGenerationTargetStatus : this.mSourceGenerationTargetStatus, this.fPackageStatus, this.fTypeNameStatus} : new IStatus[]{this.fPackageStatus};
        this.updateStatus(status);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.handlePageCompletion();
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.mInCreationMode = true;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createGenerationTarget(composite);
        this.createSpacer(composite);
        this.createSeparator(composite, nColumns);
        this.createClassDetailsGroup(composite, nColumns);
        this.createOptionsGroup(composite);
        this.addEventHandlers();
        this.setControl((Control)composite);
        this.mInCreationMode = false;
        this.mSourceSelect.setSelection(true);
        this.setSourceSelected();
        this.handlePageCompletion();
    }

    private void createJarOptionGroup(Composite composite) {
        GridData data = new GridData();
        this.mExportClassesOnly = new Button(composite, 16416);
        this.mExportClassesOnly.setText(mTPool.getText(1083));
        this.mExportClassesOnly.setEnabled(this.mJarSelect.getSelection());
        this.mExportClassesOnly.addListener(13, (Listener)this);
    }

    private void createClassDetailsGroup(Composite composite, int nColumns) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(mTPool.getText(1070));
        textLabel.setFont(JFaceResources.getBannerFont());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        textLabel.setLayoutData((Object)data);
        this.createPackageControls(composite, nColumns);
        this.createClassControl(composite);
        Label placeHolder = new Label(composite, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = false;
        placeHolder.setLayoutData((Object)data);
    }

    private void createClassControl(Composite composite) {
        GridData data = new GridData();
        Label textLabel = new Label(composite, 0);
        textLabel.setText(mTPool.getText(1003));
        textLabel.setLayoutData((Object)data);
        data = new GridData();
        this.mClass = new Text(composite, 2048);
        this.mClass.setText(this.mInitialClass);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.mClass.setLayoutData((Object)data);
        data = new GridData();
        Label portTypeLabel = new Label(composite, 0);
        portTypeLabel.setText("_PortType");
        data.horizontalSpan = 2;
        portTypeLabel.setLayoutData((Object)data);
    }

    public String getTypeName() {
        if (this.mClass == null) {
            return "";
        }
        return this.mClass.getText() + "_PortType";
    }

    public void setTypeName(String name, boolean canBeModified) {
        if (this.mClass == null) {
            this.mInitialClass = name;
            return;
        }
        if (name.length() > 0) {
            int index = name.lastIndexOf("_PortType");
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            name = name.substring(0, index);
        }
        this.mClass.setText(name);
        this.mClass.setEnabled(canBeModified);
    }

    private void createGenerationTarget(Composite parent) {
        this.createGenerationLayout(parent);
    }

    private void createGenerationLayout(Composite parent) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(mTPool.getText(1056));
        textLabel.setFont(JFaceResources.getBannerFont());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        textLabel.setLayoutData((Object)data);
        this.mSourceSelect = new Button(parent, 16);
        this.mSourceSelect.setText(mTPool.getText(1053));
        data = new GridData();
        this.mSourceSelect.setLayoutData((Object)data);
        this.mSourcePath = new Text(parent, 2048);
        this.mSourcePath.setText(this.mInitialSourcePath);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.mSourcePath.setLayoutData((Object)data);
        this.mSourceBrowse = new Button(parent, 8);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = 1;
        data.heightHint = SWTUtil.getButtonHeigthHint((Button)this.mSourceBrowse);
        data.widthHint = SWTUtil.getButtonWidthHint((Button)this.mSourceBrowse);
        this.mSourceBrowse.setText(mTPool.getText(1054));
        this.mSourceBrowse.setLayoutData((Object)data);
        this.mSourceBrowse.setEnabled(this.mCanbeModified);
        this.mJarSelect = new Button(parent, 16);
        this.mJarSelect.setText(mTPool.getText(1052));
        data = new GridData();
        this.mJarSelect.setLayoutData((Object)data);
        this.mJarPath = new Text(parent, 2048);
        this.mJarPath.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.mJarPath.setLayoutData((Object)data);
        this.mJarBrowse = new Button(parent, 8);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = 1;
        data.heightHint = SWTUtil.getButtonHeigthHint((Button)this.mJarBrowse);
        data.widthHint = SWTUtil.getButtonWidthHint((Button)this.mJarBrowse);
        this.mJarBrowse.setText(mTPool.getText(1055));
        this.mJarBrowse.setLayoutData((Object)data);
    }

    public void addGenerationTargetChangedListener(GenerationTargetChangedListener listener) {
        this.mGenerationTargetChangedListeners.add(listener);
    }

    public void removeGenerationTargetChangedListener(GenerationTargetChangedListener listener) {
        ((AbstractCollection)this.mGenerationTargetChangedListeners).remove(listener);
    }

    private void fireGenerationTargetChangedEvent(IGenerationData generationData) {
        GenerationTargetChangedEvent generationTargetChangedEvent = new GenerationTargetChangedEvent((Object)this, generationData);
        Iterator iter = ((AbstractList)this.mGenerationTargetChangedListeners).iterator();
        while (iter.hasNext()) {
            GenerationTargetChangedListener listener = (GenerationTargetChangedListener)iter.next();
            if (listener == null) continue;
            listener.generationTargetChanged(generationTargetChangedEvent);
        }
    }

    private void setSourceSelected() {
        this.setGenerationData((IGenerationData)this.mSourceGenerationData);
        this.enableControls(this.mSourcePath, this.mSourceBrowse, this.mJarPath, this.mJarBrowse);
        this.handlePageCompletion();
    }

    private void setJarSelected() {
        this.setGenerationData((IGenerationData)this.mJarGenerationData);
        this.enableControls(this.mJarPath, this.mJarBrowse, this.mSourcePath, this.mSourceBrowse);
        this.handlePageCompletion();
    }

    private void enableControls(Text textToEnable, Button buttonToEnable, Text textToDisable, Button buttonToDisable) {
        textToEnable.setEnabled(true);
        buttonToEnable.setEnabled(true);
        textToDisable.setText("");
        textToDisable.setEnabled(false);
        buttonToDisable.setEnabled(false);
    }

    private void createOptionsGroup(Composite composite) {
        GridData data = new GridData();
        Label textLabel = new Label(composite, 0);
        textLabel.setText(mTPool.getText(1080));
        textLabel.setFont(JFaceResources.getBannerFont());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        textLabel.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 4;
        Composite optionsGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)data);
        this.mCompileAfterGeneration = new Button(optionsGroup, 16416);
        this.mCompileAfterGeneration.setText(mTPool.getText(1082));
        this.mCompileAfterGeneration.addListener(13, (Listener)this);
        this.mOverwrite = new Button(optionsGroup, 16416);
        this.mOverwrite.setText(mTPool.getText(1081));
        this.mOverwrite.addListener(13, (Listener)this);
        textLabel.setVisible(false);
        optionsGroup.setVisible(false);
    }

    private void addEventHandlers() {
        this.mJarPath.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                RFCClassDetailsPage.this.handleNewJarPath();
            }
        });
        this.mJarSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RFCClassDetailsPage.this.setJarSelected();
            }
        });
        this.mSourceSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RFCClassDetailsPage.this.setSourceSelected();
            }
        });
        this.mJarBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RFCClassDetailsPage.this.handleJarBrowse();
            }
        });
        this.mSourceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RFCClassDetailsPage.this.handleSourceBrowse();
            }
        });
        this.mSourcePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RFCClassDetailsPage.this.handlePageCompletion();
            }
        });
        this.mJarPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RFCClassDetailsPage.this.mJarPathDirty = true;
                RFCClassDetailsPage.this.handlePageCompletion();
            }
        });
        this.mClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RFCClassDetailsPage.this.handlePageCompletion();
            }
        });
    }

    private void expandJarPathName() {
        if (this.mJarPath.getText().trim().length() > 0) {
            this.mJarPath.setText(RFCClassDetailsPage.getJarPath(this.mJarPath.getText().trim()).toOSString());
        }
    }

    public void handleEvent(Event e) {
        this.handlePageCompletion();
    }

    private void handlePageCompletion() {
        if (this.mInCreationMode) {
            return;
        }
        this.updateGenerationData();
        this.fPackageStatus = this.packageChanged();
        this.fTypeNameStatus = this.typeNameChanged();
        this.mJarGenerationTargetStatus = this.jarGenerationTargetChanged();
        this.mSourceGenerationTargetStatus = this.containerChanged();
        this.doStatusUpdate();
    }

    protected IStatus typeNameChanged() {
        IStatus superStatus = super.typeNameChanged();
        if (superStatus.getSeverity() != 4 && this.getRawTypeName().trim().length() == 0) {
            return new Status(SAPJavaConnectivityBuilderUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, mTPool.getText(1101));
        }
        if (superStatus.getSeverity() == 4 && superStatus.getMessage().equalsIgnoreCase(NewWizardMessages.getString((String)"NewTypeWizardPage.error.TypeNameExists"))) {
            return new Status(SAPJavaConnectivityBuilderUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "");
        }
        return superStatus;
    }

    private Status jarGenerationTargetChanged() {
        Status status = new Status(SAPJavaConnectivityBuilderUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, PAGE_DESCRIPTION);
        if (this.mJarSelect.getSelection()) {
            if (this.mJarPath.getText().length() == 0) {
                status.setError(mTPool.getText(1090));
            } else if (this.mGenerationData.getGenerationPath().toString().endsWith("/")) {
                status.setError(mTPool.getText(1091));
            } else {
                File targetFile = RFCClassDetailsPage.getPathFromString(this.mGenerationData.getGenerationPath()).toFile();
                if (targetFile.exists()) {
                    if (RFCClassDetailsPage.isDirectory(targetFile)) {
                        status.setError(mTPool.getText(1092));
                    } else if (!RFCClassDetailsPage.isFileWritable(targetFile)) {
                        status.setError(mTPool.getText(1093));
                    }
                }
            }
        }
        return status;
    }

    private void updateGenerationData() {
        if (this.mJarSelect.getSelection()) {
            this.mJarGenerationData.setGenerationPath(this.mJarPath.getText());
            this.setCommonGenerationDataFields((IGenerationData)this.mJarGenerationData);
            if (this.mJarGenerationData != this.mGenerationData) {
                this.setGenerationData(this.mGenerationData);
            }
        } else {
            this.mSourceGenerationData.setPackageFragmentRoot(this.getPackageFragmentRoot());
            this.mSourceGenerationData.setPackageFragment(this.getPackageFragment());
            this.mSourceGenerationData.setGenerationPath(this.mSourcePath.getText());
            this.setCommonGenerationDataFields((IGenerationData)this.mSourceGenerationData);
            if (this.mSourceGenerationData != this.mGenerationData) {
                this.setGenerationData((IGenerationData)this.mSourceGenerationData);
            }
        }
    }

    private String getRawTypeName() {
        if (this.mClass == null) {
            return "";
        }
        return this.mClass.getText();
    }

    private void setCommonGenerationDataFields(IGenerationData generationData) {
        generationData.setPackageName(this.getPackageText());
        generationData.setClassName(this.getRawTypeName());
        generationData.setOverwriteWithoutWarning(this.mOverwrite.getSelection());
        generationData.setCompileAfterGeneration(this.mCompileAfterGeneration.getSelection());
    }

    private void handleSourceBrowse() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if ((root = this.chooseSourceContainer((IJavaElement)root)) != null) {
            this.setPackageFragmentRoot(root, true);
            this.handlePageCompletion();
        }
    }

    private void handleJarBrowse() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        this.expandJarPathName();
        String currentSourceString = this.mJarPath.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
        } else {
            dialog.setFileName(currentSourceString);
        }
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.mJarPath.setText(selectedFileName);
            this.handleNewJarPath();
        }
    }

    private void handleNewJarPath() {
        if (this.mJarPathDirty) {
            this.expandJarPathName();
            this.updateGenerationData();
            this.fireGenerationTargetChangedEvent(this.mGenerationData);
            this.handlePageCompletion();
            this.mJarPathDirty = false;
        }
    }

    protected IStatus packageChanged() {
        super.packageChanged();
        Status status = new Status(SAPJavaConnectivityBuilderUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, PAGE_DESCRIPTION);
        String packName = this.getPackageText().trim();
        if (packName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packName);
            if (val.getSeverity() == 4) {
                status.setError(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.error.InvalidPackageName", (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.DiscouragedPackageName", (Object)val.getMessage()));
            }
        } else {
            status.setError(mTPool.getText(1031));
            return status;
        }
        return status;
    }

    public IGenerationData getGenerationData() {
        return this.mGenerationData;
    }

    public void setGenerationData(IGenerationData generationData) {
        this.mGenerationData = generationData;
        this.fireGenerationTargetChangedEvent(this.mGenerationData);
    }

    public boolean isGenerationTargetChanged() {
        return this.mGenerationTargetChanged;
    }

    public void setGenerationTargetChanged(boolean generationTargetChanged) {
        this.mGenerationTargetChanged = generationTargetChanged;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean createGenerationTargetIfRequired() {
        if (this.mGenerationData instanceof IJarGenerationData) {
            File generationFile = RFCClassDetailsPage.getPathFromString(this.mGenerationData.getGenerationPath()).toFile();
            if (generationFile.exists()) {
                return true;
            }
            boolean canCreateFile = MessageDialog.openConfirm((Shell)this.getContainer().getShell(), (String)mTPool.getText(1065), (String)(mTPool.getText(1066) + generationFile + mTPool.getText(1067)));
            if (!canCreateFile) {
                return false;
            }
            try {
                generationFile.createNewFile();
                this.mCreatedGenerationTargets.add(generationFile);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public void removeCreatedGenerationTargets() {
    }

    public String getPackageFragmentRootText() {
        if (this.mSourcePath == null) {
            return "";
        }
        return this.mSourcePath.getText();
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        String str;
        super.setPackageFragmentRoot(root, canBeModified);
        this.mSourceGenerationData.setPackageFragmentRoot(root);
        String string = str = root == null ? "" : root.getPath().makeRelative().toString();
        if (this.mSourcePath != null) {
            this.mSourcePath.setText(str);
        } else {
            this.mInitialSourcePath = str;
        }
        if (this.mSourceBrowse != null) {
            this.mSourceBrowse.setEnabled(canBeModified);
        } else {
            this.mCanbeModified = canBeModified;
        }
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement initElement) {
        Class[] acceptedClasses = new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = RFCClassDetailsPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = RFCClassDetailsPage.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{class$org$eclipse$jdt$core$IJavaModel == null ? (class$org$eclipse$jdt$core$IJavaModel = RFCClassDetailsPage.class$("org.eclipse.jdt.core.IJavaModel")) : class$org$eclipse$jdt$core$IJavaModel, class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = RFCClassDetailsPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = RFCClassDetailsPage.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(NewWizardMessages.getString((String)"NewContainerWizardPage.ChooseSourceContainerDialog.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewContainerWizardPage.ChooseSourceContainerDialog.description"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()));
        dialog.setInitialSelection((Object)initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        super.setPackageFragment(pack, canBeModified);
        this.mSourceGenerationData.setPackageFragment(this.getPackageFragment());
    }

    public IGenerationManager getGenerationManager() {
        IGenerationManager generationManager = null;
        if (this.mGenerationData instanceof ISourceGenerationData) {
            generationManager = R3Service.getInstance().getGenerationManagerFactory().getGenerationManager(class$com$sap$ide$jcb$core$service$generation$ISourceGenerationData == null ? (class$com$sap$ide$jcb$core$service$generation$ISourceGenerationData = RFCClassDetailsPage.class$("com.sap.ide.jcb.core.service.generation.ISourceGenerationData")) : class$com$sap$ide$jcb$core$service$generation$ISourceGenerationData);
        } else if (this.mGenerationData instanceof IJarGenerationData) {
            generationManager = R3Service.getInstance().getGenerationManagerFactory().getGenerationManager(class$com$sap$ide$jcb$core$service$generation$IJarGenerationData == null ? (class$com$sap$ide$jcb$core$service$generation$IJarGenerationData = RFCClassDetailsPage.class$("com.sap.ide.jcb.core.service.generation.IJarGenerationData")) : class$com$sap$ide$jcb$core$service$generation$IJarGenerationData);
        }
        if (generationManager != null) {
            generationManager.setGenerationData(this.mGenerationData);
            return generationManager;
        }
        return null;
    }

    private void initializeFields() {
    }

    public void saveFields() {
    }

    public void init(IMemento memento) {
        IMemento generationMemento;
        IMemento classMemento = memento.getChild(CLASS_TAG);
        if (classMemento != null) {
            String className = classMemento.getString(CLASS_NAME_ATTRIBUTE);
            String packageName = classMemento.getString(CLASS_PACKAGE_ATTRIBUTE);
            boolean j2ee = Boolean.valueOf(classMemento.getString(CLASS_J2EE_ATTRIBUTE));
            if (className != null) {
                this.setTypeName(className, true);
            }
        }
        if ((generationMemento = memento.getChild(GENERATION_TARGET_TAG)) != null) {
            String generationTargetType = generationMemento.getString(GENERATION_TARGET_TYPE_ATTRIBUTE);
            boolean overwrite = Boolean.valueOf(generationMemento.getString(GENERATION_TARGET_OVERWRITE_ATTRIBUTE));
            boolean compile = Boolean.valueOf(generationMemento.getString(GENERATION_TARGET_COMPILE_ATTRIBUTE));
            this.mOverwrite.setSelection(overwrite);
            this.mCompileAfterGeneration.setSelection(compile);
        }
    }

    public void saveState(IMemento memento) {
        IMemento classMemento = memento.getChild(CLASS_TAG);
        if (classMemento == null) {
            classMemento = memento.createChild(CLASS_TAG);
        }
        classMemento.putString(CLASS_NAME_ATTRIBUTE, this.getTypeName());
        classMemento.putString(CLASS_PACKAGE_ATTRIBUTE, this.getPackageText());
        IMemento generationMemento = memento.getChild(GENERATION_TARGET_TAG);
        if (generationMemento == null) {
            generationMemento = memento.createChild(GENERATION_TARGET_TAG);
        }
        if (this.mGenerationData instanceof IJarGenerationData) {
            generationMemento.putString(GENERATION_TARGET_TYPE_ATTRIBUTE, GENERATION_TARGET_JAR);
        } else if (this.mGenerationData instanceof IJarGenerationData) {
            generationMemento.putString(GENERATION_TARGET_TYPE_ATTRIBUTE, GENERATION_TARGET_SOURCE);
        }
        generationMemento.putString(GENERATION_TARGET_OVERWRITE_ATTRIBUTE, String.valueOf(this.mOverwrite.getSelection()));
        generationMemento.putString(GENERATION_TARGET_COMPILE_ATTRIBUTE, String.valueOf(this.mCompileAfterGeneration.getSelection()));
    }

    public static IPath getPathFromString(String text) {
        IPath path = new Path(text).makeAbsolute();
        if (path.getDevice() != null) {
            return path;
        }
        File file = new File(text);
        file = file.getAbsoluteFile();
        try {
            path = new Path(file.getCanonicalPath()).makeAbsolute();
        }
        catch (IOException e) {
            return path;
        }
        return path;
    }

    public static boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists()) {
            return !RFCClassDetailsPage.isDirectory(targetFile) && RFCClassDetailsPage.isFileWritable(targetFile);
        }
        return true;
    }

    private static boolean isFileWritable(File targetFile) {
        return targetFile.canWrite();
    }

    private static boolean isDirectory(File targetFile) {
        return targetFile.isDirectory();
    }

    public static IPath getJarPath(String jarPathText) {
        IPath path = RFCClassDetailsPage.getPathFromString(jarPathText);
        if (path.segmentCount() > 0 && RFCClassDetailsPage.ensureTargetFileIsValid(path.toFile()) && path.getFileExtension() == null) {
            path = path.addFileExtension(JAR_EXTENSION);
        }
        return path;
    }

    public IWizardPage getNextPage() {
        if (!this.createGenerationTargetIfRequired()) {
            return this;
        }
        return super.getNextPage();
    }

    private IDialogSettings getDialogSection(String section, boolean create) {
        IDialogSettings theDialogSettings = null;
        IDialogSettings theSectionSettings = null;
        theDialogSettings = this.getDialogSettings();
        if (theDialogSettings == null) {
            theDialogSettings = SAPJavaConnectivityBuilderUIPlugin.getDefault().getDialogSettings();
        }
        if (theDialogSettings == null) {
            return null;
        }
        theSectionSettings = theDialogSettings.getSection(section);
        if (create && theSectionSettings == null) {
            theSectionSettings = theDialogSettings.addNewSection(section);
        }
        return theSectionSettings;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    public void performFinish() {
        this.saveFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PAGE_TITLE = PAGE_NAME = mTPool.getText(1001);
        PAGE_DESCRIPTION = mTPool.getText(1002);
    }
}

