/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class TestTree
implements TestTreeNode {
    private static final String TAG_TEST_TREE = "TESTS";
    private static final String PARAMETER_TEST_CATEGORY_NAME = "CATEGORY";
    private static final String PARAMETER_RESOURCE_BUNDLE = "RESOURCE_BUNDLE";
    private Vector nodes = new Vector();
    private String name = null;
    private String resourceBundle;

    public TestTree() {
    }

    public TestTree(StructureTree sTree) throws BadTreeException {
        String category = sTree.getParameter(PARAMETER_TEST_CATEGORY_NAME);
        if (category != null) {
            this.name = category;
        }
        this.resourceBundle = sTree.getParameter(PARAMETER_RESOURCE_BUNDLE);
        StructureTree[] children = sTree.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getTag().equals(TAG_TEST_TREE)) {
                this.nodes.add(new TestTree(children[i]));
            } else {
                this.nodes.add(new TestDefinition(children[i]));
            }
            ++i;
        }
    }

    public int getNodeType() {
        return 2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void addTree(TestTreeNode tree) {
        boolean found = false;
        Iterator iter = ((AbstractList)this.nodes).iterator();
        while (iter.hasNext() && !found) {
            TestTreeNode element = (TestTreeNode)iter.next();
            if (tree.getNodeType() != element.getNodeType()) continue;
            if (tree.getNodeType() == 1) {
                if (!((TestDescriptionInterface)tree).getName().equals(((TestDescriptionInterface)element).getName())) continue;
                found = true;
                continue;
            }
            if (!((TestTree)tree).getName().equals(((TestTree)element).getName())) continue;
            TestTreeNode[] children = ((TestTree)tree).getNodes();
            int i = 0;
            while (i < children.length) {
                ((TestTree)element).addTree(children[i]);
                ++i;
            }
            found = true;
        }
        if (!found) {
            this.nodes.add(tree);
        }
    }

    public TestTreeNode[] getNodes() {
        return this.nodes.toArray(new TestTreeNode[this.nodes.size()]);
    }

    public TestDescriptionInterface[] getAllLeaves() {
        Vector allLeaves = this.getLeafVector();
        return allLeaves.toArray(new TestDescriptionInterface[allLeaves.size()]);
    }

    public StructureTree toStructureTree() {
        Header header = new Header(TAG_TEST_TREE);
        if (this.name != null) {
            header.setParameter(PARAMETER_TEST_CATEGORY_NAME, this.name);
        }
        if (this.resourceBundle != null) {
            header.setParameter(PARAMETER_RESOURCE_BUNDLE, this.resourceBundle);
        }
        StructureTree out = new StructureTree(header);
        Iterator iter = ((AbstractList)this.nodes).iterator();
        while (iter.hasNext()) {
            TestTreeNode element = (TestTreeNode)iter.next();
            out.addNewChild(element.toStructureTree());
        }
        return out;
    }

    private Vector getLeafVector() {
        Vector<TestTreeNode> allTests = new Vector<TestTreeNode>();
        TestTreeNode[] nodes = this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getNodeType() == 1) {
                allTests.add(nodes[i]);
            } else {
                allTests.addAll(((TestTree)nodes[i]).getLeafVector());
            }
            ++i;
        }
        return allTests;
    }
}

