/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class TestSet
implements Persistable {
    private String name;
    private Vector tests = new Vector();
    public static final String NAME_TAG = "NAME";
    private static final String PARAMETER_TAG_TEST_SET = "TEST_SET";

    public TestSet(String name) {
        this.name = name;
    }

    public TestSet(String name, Test[] tests) {
        this.name = name;
        int i = 0;
        while (i < tests.length) {
            this.tests.add(tests[i]);
            ++i;
        }
    }

    public TestSet(StructureTree tree) throws BadTreeException {
        this.name = tree.getParameter(NAME_TAG);
        StructureTree[] singleTestTrees = tree.getChildren("TEST");
        int i = 0;
        while (i < singleTestTrees.length) {
            this.tests.add(new Test(singleTestTrees[i]));
            ++i;
        }
    }

    public void addTest(Test test) {
        this.tests.add(test);
    }

    public void removeTest(Test test) {
        this.tests.remove(test);
    }

    public StructureTree toStructureTree() {
        Header header = new Header(PARAMETER_TAG_TEST_SET);
        header.setParameter(NAME_TAG, this.name);
        StructureTree rootTree = new StructureTree(header);
        Iterator iter = ((AbstractList)this.tests).iterator();
        while (iter.hasNext()) {
            Test test = (Test)iter.next();
            rootTree.addNewChild(test.toStructureTree());
        }
        return rootTree;
    }

    public Test[] getTests() {
        return this.tests.toArray(new Test[this.tests.size()]);
    }

    public Test[] getActiveTests() {
        Vector<Test> activeTests = new Vector<Test>();
        Iterator iter = ((AbstractList)this.tests).iterator();
        while (iter.hasNext()) {
            Test test = (Test)iter.next();
            if (!test.isActive()) continue;
            activeTests.add(test);
        }
        return activeTests.toArray(new Test[activeTests.size()]);
    }

    public Test getTest(String name) {
        Iterator iter = ((AbstractList)this.tests).iterator();
        while (iter.hasNext()) {
            Test test = (Test)iter.next();
            if (!test.getName().equals(name)) continue;
            return test;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

