/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class TestMessageDescription
implements ITestMessageDescription {
    private String key;
    private String displayName;
    private int prio;

    public TestMessageDescription(String key, String displayName, int prio) {
        this.key = key;
        this.displayName = displayName;
        this.prio = prio;
    }

    public static TestMessageDescription fromStructureTree(StructureTree tree) {
        if (!"MESSAGE".equals(tree.getTag())) {
            throw new IllegalArgumentException();
        }
        String prioString = tree.getParameter("PRIO").trim();
        int prio = "DYNAMIC".equalsIgnoreCase(prioString) ? -1 : Integer.parseInt(prioString);
        return new TestMessageDescription(tree.getParameter("KEY"), tree.getParameter("DISPLAYNAME"), prio);
    }

    public String getKey() {
        return this.key;
    }

    public int getPriority() {
        return this.prio;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.key;
    }

    public StructureTree toStructureTree() {
        Header msgHeader = new Header("MESSAGE");
        msgHeader.setParameter("KEY", this.key);
        msgHeader.setParameter("PRIO", this.prio == -1 ? "DYNAMIC" : String.valueOf(this.prio));
        if (this.displayName != null) {
            msgHeader.setParameter("DISPLAYNAME", this.displayName);
        }
        return new StructureTree(msgHeader);
    }
}

