/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.TestMessageDescription;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.io.Serializable;
import java.util.HashMap;

public class Test {
    private final String name;
    private ParameterInterface[] parameters;
    private ITestMessageDescription[] messages;
    private boolean active = true;
    private String[] codeClassificationStrings = ALL;
    public static final String APPLIES_TO_TAG = "APPLIES_TO";
    public static final String NAME_TAG = "NAME";
    public static final String ACTIVE_TAG = "ACTIVE";
    private static final String[] ALL = new String[]{"all"};

    public Test(String testName, ParameterInterface[] parameters) {
        this(testName, parameters, new ITestMessageDescription[0], ALL, true);
    }

    public Test(String testName, ParameterInterface[] parameters, boolean active) {
        this(testName, parameters, new ITestMessageDescription[0], ALL, active);
    }

    public Test(String testName, ParameterInterface[] parameters, ITestMessageDescription[] messages, String[] appliesTo, boolean active) {
        this.name = testName;
        this.parameters = parameters;
        this.messages = messages;
        this.active = active;
        this.codeClassificationStrings = appliesTo;
    }

    public Test(StructureTree tree) throws BadTreeException {
        int i;
        this.name = tree.getParameter(NAME_TAG);
        String active = tree.getParameter(ACTIVE_TAG);
        this.active = active != null ? Boolean.valueOf(active) : true;
        StructureTree[] params = tree.getChildren("INPUT_PARAMETER");
        this.parameters = new ParameterInterface[params.length];
        int i2 = 0;
        while (i2 < params.length) {
            this.parameters[i2] = ParameterTool.createParameter(params[i2]);
            ++i2;
        }
        StructureTree msgsTree = tree.getOnlyChild("MESSAGES");
        if (msgsTree != null) {
            StructureTree[] msgTrees = msgsTree.getChildren("MESSAGE");
            this.messages = new ITestMessageDescription[msgTrees.length];
            i = 0;
            while (i < msgTrees.length) {
                this.messages[i] = TestMessageDescription.fromStructureTree(msgTrees[i]);
                ++i;
            }
        } else {
            this.messages = new ITestMessageDescription[0];
        }
        StructureTree[] appliesToTrees = tree.getChildren(APPLIES_TO_TAG);
        if (appliesToTrees.length > 0) {
            this.codeClassificationStrings = new String[appliesToTrees.length];
            i = 0;
            while (i < appliesToTrees.length) {
                this.codeClassificationStrings[i] = appliesToTrees[i].getText();
                ++i;
            }
        }
    }

    public String[] getCodeClassification() {
        return this.codeClassificationStrings;
    }

    public String getName() {
        return this.name;
    }

    public ParameterInterface[] getParameters() {
        return this.parameters;
    }

    public void setMessages(ITestMessageDescription[] messages) {
        this.messages = messages;
    }

    public ITestMessageDescription[] getMessages() {
        return this.messages;
    }

    public ParameterInterface getParameter(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.parameters.length) {
            if (name.equals(this.parameters[i].getName())) {
                return this.parameters[i];
            }
            ++i;
        }
        return null;
    }

    public void setParameters(ParameterInterface[] newParameters) {
        this.parameters = newParameters;
    }

    public boolean paramsOkay() {
        if (null == this.parameters) {
            return true;
        }
        boolean okay = true;
        int i = 0;
        while (okay && i < this.parameters.length) {
            Serializable value = this.parameters[i].getValue();
            okay = value instanceof String ? 0 != ((String)((Object)value)).length() : null != value;
            ++i;
        }
        return okay;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public StructureTree toStructureTree() {
        Header header = new Header("TEST");
        header.setParameter(NAME_TAG, this.name);
        header.setParameter(ACTIVE_TAG, String.valueOf(this.active));
        StructureTree rootTree = new StructureTree(header);
        int i = 0;
        while (i < this.parameters.length) {
            rootTree.addNewChild(this.parameters[i].toStructureTree());
            ++i;
        }
        if (this.messages != null && this.messages.length > 0) {
            StructureTree msgsTree = rootTree.addNewChild(new Header("MESSAGES"));
            int i2 = 0;
            while (i2 < this.messages.length) {
                msgsTree.addNewChild(this.messages[i2].toStructureTree());
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.codeClassificationStrings.length) {
            StructureTree newTree = new StructureTree(new Header(APPLIES_TO_TAG));
            newTree.setText(this.codeClassificationStrings[i3]);
            rootTree.addNewChild(newTree);
            ++i3;
        }
        return rootTree;
    }

    public static ITestMessageDescription[] mergeMessages(TestDescriptionInterface testDefinition, Test requestTest) {
        ITestMessageDescription[] originalMsgs = testDefinition.getMessages();
        HashMap<String, ITestMessageDescription> msgMap = new HashMap<String, ITestMessageDescription>(originalMsgs.length);
        int i = 0;
        while (i < originalMsgs.length) {
            msgMap.put(originalMsgs[i].getKey(), originalMsgs[i]);
            ++i;
        }
        ITestMessageDescription[] requestMsgs = requestTest.getMessages();
        int i2 = 0;
        while (i2 < requestMsgs.length) {
            msgMap.put(requestMsgs[i2].getKey(), requestMsgs[i2]);
            ++i2;
        }
        return msgMap.values().toArray(new ITestMessageDescription[0]);
    }
}

