/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.ascii.StringBuf;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.io.Serializable;

public final class StringParameter
implements ParameterInterface {
    protected final String name;
    private String value;
    private String type = "STRING";

    StringParameter(String name, String value) {
        this(name, value, null);
    }

    StringParameter(String name, String value, String type) {
        this.name = name;
        this.value = value;
        if (type == null || !type.equals("STRING") && !type.equals("FILE") && !type.equals("DIRECTORY")) {
            throw new IllegalArgumentException("type " + type + " is invalid");
        }
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getValueTrue() {
        return this.value;
    }

    public String valueToString() {
        if (null == this.value) {
            return "";
        }
        return this.value;
    }

    public String toString() {
        String valString = this.valueToString();
        StringBuf buf = new StringBuf(this.name.length() + valString.length() + 10);
        return buf.append(this.name).append(':').append(valString).toString();
    }

    public void setValue(Serializable newValue) {
        this.value = newValue != null ? newValue.toString() : null;
    }

    public StructureTree toStructureTree() {
        Header paramHeader = new Header("INPUT_PARAMETER");
        paramHeader.setParameter("NAME", this.name);
        paramHeader.setParameter("TYPE", this.type);
        StructureTree paramTree = new StructureTree(paramHeader);
        if (null != this.value && 0 != this.value.length()) {
            Header contentHeader = new Header("VALUE");
            StructureTree contentTree = new StructureTree(contentHeader);
            paramTree.addNewChild(contentTree);
            contentTree.setText(this.value);
        }
        return paramTree;
    }

    static StringParameter createFromStructureTree(String nameInfo, StructureTree treeInfo) throws BadTreeException {
        StructureTree[] contents = treeInfo.getChildren("VALUE");
        if (null == contents || 0 == contents.length) {
            return new StringParameter(nameInfo, null, treeInfo.getParameter("TYPE"));
        }
        if (1 != contents.length) {
            throw new BadTreeException("illegal value content");
        }
        return new StringParameter(nameInfo, contents[0].getText(), treeInfo.getParameter("TYPE"));
    }
}

