/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.BooleanParameter;
import com.sap.tc.jtools.jtci.DeepStructureParameter;
import com.sap.tc.jtools.jtci.FloatParameter;
import com.sap.tc.jtools.jtci.IntParameter;
import com.sap.tc.jtools.jtci.StringArrayParameter;
import com.sap.tc.jtools.jtci.StringParameter;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class ParameterTool {
    public static final String PAR_TYPE_STRING = "STRING";
    public static final String PAR_TYPE_STRING_ARRAY = "STRING[]";
    public static final String PAR_TYPE_INT = "INT";
    public static final String PAR_TYPE_FLOAT = "FLOAT";
    public static final String PAR_TYPE_BOOLEAN = "BOOLEAN";
    public static final String PAR_TYPE_FILE = "FILE";
    public static final String PAR_TYPE_FILE_ARRAY = "FILE[]";
    public static final String PAR_TYPE_DIRECTORY = "DIRECTORY";
    public static final String PAR_TYPE_DIRECTORY_ARRAY = "DIRECTORY[]";
    public static final String PAR_TYPE_DEEP_STRUCTURE = "DEEP STRUCTURE";
    public static final String PAR_MSG_KEY = "__MSG_KEY";
    public static final String PAR_LINK = "__LINK";
    public static final String PAR_EXCEPTION = "EXCEPTION";
    private static final String[] TYPE_NAMES = new String[]{"STRING", "STRING[]", "INT", "FLOAT", "BOOLEAN", "FILE", "FILE[]", "DIRECTORY", "DIRECTORY[]", "DEEP STRUCTURE"};

    public static String[] getParameterTypes() {
        return TYPE_NAMES;
    }

    public static ParameterInterface createParameter(StructureTree pStructureTree) throws BadTreeException {
        Header header = pStructureTree.getHeader();
        if (null == header) {
            throw new BadTreeException("no header");
        }
        String name = header.getParameter("NAME");
        String type = header.getParameter("TYPE");
        if (null == name || null == type) {
            throw new BadTreeException("illegal header format");
        }
        if (type.equals(PAR_TYPE_INT)) {
            return IntParameter.createFromStructureTree(pStructureTree);
        }
        if (type.equals(PAR_TYPE_FLOAT)) {
            return FloatParameter.createFromStructureTree(pStructureTree);
        }
        if (type.equals(PAR_TYPE_BOOLEAN)) {
            return BooleanParameter.createFromStructureTree(pStructureTree);
        }
        if (type.equals(PAR_TYPE_STRING) || type.equals(PAR_TYPE_FILE) || type.equals(PAR_TYPE_DIRECTORY)) {
            return StringParameter.createFromStructureTree(name, pStructureTree);
        }
        if (type.equals(PAR_TYPE_STRING_ARRAY) || type.equals(PAR_TYPE_DIRECTORY_ARRAY) || type.equals(PAR_TYPE_FILE_ARRAY)) {
            return StringArrayParameter.createFromStructureTree(name, pStructureTree);
        }
        if (type.equals(PAR_TYPE_DEEP_STRUCTURE)) {
            return DeepStructureParameter.createFromStructureTree(name, pStructureTree);
        }
        throw new BadTreeException("unknown type: " + type);
    }

    public static ParameterInterface createParameter(String name, String type, Object value) {
        if (ParameterTool.isSimpleType(type)) {
            if (value != null && !(value instanceof String)) {
                throw new IllegalArgumentException("value must be of type String");
            }
            if (type.equals(PAR_TYPE_BOOLEAN)) {
                return new BooleanParameter(name, value == null ? false : Boolean.valueOf((String)value));
            }
            if (type.equals(PAR_TYPE_INT)) {
                return new IntParameter(name, (String)value);
            }
            if (type.equals(PAR_TYPE_FLOAT)) {
                return new FloatParameter(name, (String)value);
            }
            if (type.equals(PAR_TYPE_STRING) || type.equals(PAR_TYPE_FILE) || type.equals(PAR_TYPE_DIRECTORY)) {
                return new StringParameter(name, (String)value, type);
            }
            throw new IllegalArgumentException("unknown type: " + type);
        }
        if (ParameterTool.isArrayType(type)) {
            if (value != null && !(value instanceof String[])) {
                throw new IllegalArgumentException("value must be of type String[]");
            }
            return new StringArrayParameter(name, (String[])value, type);
        }
        if (type.equals(PAR_TYPE_DEEP_STRUCTURE)) {
            if (value != null && !(value instanceof StructureTree)) {
                throw new IllegalArgumentException("value must be of type StructureTree");
            }
            return new DeepStructureParameter(name, (StructureTree)value);
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    public static boolean isSimpleType(String type) {
        return PAR_TYPE_STRING.equals(type) || PAR_TYPE_FILE.equals(type) || PAR_TYPE_BOOLEAN.equals(type) || PAR_TYPE_FLOAT.equals(type) || PAR_TYPE_INT.equals(type) || PAR_TYPE_DIRECTORY.equals(type);
    }

    public static boolean isArrayType(String type) {
        return PAR_TYPE_STRING_ARRAY.equals(type) || PAR_TYPE_DIRECTORY_ARRAY.equals(type) || PAR_TYPE_FILE_ARRAY.equals(type);
    }

    public static boolean eq(ParameterInterface[] par1, ParameterInterface[] par2) {
        if (par1.length != par2.length) {
            return false;
        }
        int i = 0;
        while (i < par1.length) {
            if (!par1[i].getName().equals(par2[i].getName()) || !par1[i].getType().equals(par2[i].getType())) {
                return false;
            }
            if (ParameterTool.isSimpleType(par1[i].getType()) && !par1[i].valueToString().equals(par2[i].valueToString())) {
                return false;
            }
            if (ParameterTool.isArrayType(par1[i].getType())) {
                String[] a2;
                String[] a1 = (String[])par1[i].getValue();
                if (a1.length != (a2 = (String[])par2[i].getValue()).length) {
                    return false;
                }
                int j = 0;
                while (j < a1.length) {
                    if (!a1[j].equals(a2[j])) {
                        return false;
                    }
                    ++j;
                }
            }
            if (par1[i].getType().equals(PAR_TYPE_DEEP_STRUCTURE) && !((StructureTree)par1[i].getValue()).equals((StructureTree)par2[i].getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

