/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.io.Serializable;

public class IntParameter
implements ParameterInterface {
    private String name;
    private int value;

    public IntParameter(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public IntParameter(String name, String value) {
        this.name = name;
        if (value != null) {
            try {
                this.value = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    static IntParameter createFromStructureTree(StructureTree tree) throws BadTreeException {
        int value;
        Header header = tree.getHeader();
        String type = header.getParameter("TYPE");
        String name = header.getParameter("NAME");
        if (type == null || name == null | !"INT".equals(type)) {
            throw new BadTreeException();
        }
        StructureTree[] contents = tree.getChildren("VALUE");
        if (null == contents || contents.length == 0) {
            return new IntParameter(name, 0);
        }
        if (1 != contents.length) {
            throw new BadTreeException("illegal value content");
        }
        String valueString = contents[0].getText();
        if (valueString == null) {
            throw new BadTreeException();
        }
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            throw new BadTreeException(e);
        }
        return new IntParameter(name, value);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "INT";
    }

    public Serializable getValue() {
        return new Integer(this.value);
    }

    public void setValue(Serializable value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.value = (Integer)value;
    }

    public String valueToString() {
        return String.valueOf(this.value);
    }

    public StructureTree toStructureTree() {
        Header paramHeader = new Header("INPUT_PARAMETER");
        paramHeader.setParameter("NAME", this.name);
        paramHeader.setParameter("TYPE", "INT");
        StructureTree paramTree = new StructureTree(paramHeader);
        Header contentHeader = new Header("VALUE");
        StructureTree contentTree = new StructureTree(contentHeader);
        paramTree.addNewChild(contentTree);
        contentTree.setText(this.valueToString());
        return paramTree;
    }
}

