/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.ascii.StringBuf;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.Serializable;

public final class DeepStructureParameter
implements Persistable,
ParameterInterface {
    public static final String EMPTY_STRING = "";
    private StructureTree value;
    protected final String name;

    DeepStructureParameter(String name, StructureTree value) {
        this.name = name;
        this.value = value;
    }

    DeepStructureParameter(String name, Persistable object) {
        this.name = name;
        this.value = object.toStructureTree();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "DEEP STRUCTURE";
    }

    public Serializable getValue() {
        return this.value;
    }

    public StructureTree getValueTrue() {
        return this.value;
    }

    public String valueToString() {
        if (null != this.value) {
            return XMLTool.toString((StructureTree)this.value);
        }
        return EMPTY_STRING;
    }

    public String toString() {
        String valString = this.valueToString();
        StringBuf buf = new StringBuf(this.name.length() + valString.length() + 10);
        return buf.append(this.name).append(':').append(valString).toString();
    }

    public void setValue(Serializable newValue) {
        if (newValue == null) {
            this.value = null;
        } else if (newValue instanceof StructureTree) {
            this.value = (StructureTree)newValue;
        } else if (newValue instanceof Persistable) {
            this.value = ((Persistable)newValue).toStructureTree();
        } else {
            throw new IllegalArgumentException("arg must be StructureTree or Persistable");
        }
    }

    public StructureTree toStructureTree() {
        Header paramHeader = new Header("INPUT_PARAMETER");
        paramHeader.setParameter("NAME", this.name);
        paramHeader.setParameter("TYPE", "DEEP STRUCTURE");
        StructureTree paramTree = new StructureTree(paramHeader);
        if (null != this.value) {
            Header contentHeader = new Header("VALUE");
            StructureTree contentTree = new StructureTree(contentHeader);
            paramTree.addNewChild(contentTree);
            contentTree.addNewChild(this.value);
        }
        return paramTree;
    }

    static DeepStructureParameter createFromStructureTree(String nameInfo, StructureTree treeInfo) throws BadTreeException {
        StructureTree[] contents = treeInfo.getChildren("VALUE");
        if (null == contents || 0 == contents.length) {
            return new DeepStructureParameter(nameInfo, null);
        }
        if (1 != contents.length) {
            throw new BadTreeException("illegal value content");
        }
        StructureTree[] values = contents[0].getChildren();
        if (null == values || 0 == values.length) {
            return new DeepStructureParameter(nameInfo, null);
        }
        if (1 == values.length) {
            return new DeepStructureParameter(nameInfo, values[0]);
        }
        throw new BadTreeException("too much children: " + values.length);
    }
}

