/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.statistics;

import com.sap.tc.jtools.jlint.statistics.MetricResult;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TestSummary
implements Persistable {
    private static final int ERROR_INDEX = 0;
    private static final int WARNING_INDEX = 1;
    private static final int INFO_INDEX = 2;
    private Map test2Results;
    private int[] totals;

    public TestSummary(StructureTree tree) {
        this.test2Results = new HashMap();
        this.totals = new int[]{0, 0, 0};
        StructureTree[] tests = tree.getChildren("TEST");
        int i = 0;
        while (i < tests.length) {
            StructureTree[] msgKeyTrees = tests[i].getChildren("MSG_KEY");
            String testName = tests[i].getParameter("TEST_NAME");
            HashMap<String, int[]> key2Messages = new HashMap<String, int[]>();
            int j = 0;
            while (j < msgKeyTrees.length) {
                String msgKey = msgKeyTrees[j].getParameter("NAME");
                int[] count = new int[]{Integer.parseInt(msgKeyTrees[j].getParameter("ERRORS")), Integer.parseInt(msgKeyTrees[j].getParameter("WARNINGS")), Integer.parseInt(msgKeyTrees[j].getParameter("INFOS"))};
                int k = 0;
                while (k < count.length) {
                    int n = k;
                    this.totals[n] = this.totals[n] + count[k];
                    ++k;
                }
                key2Messages.put(msgKey, count);
                ++j;
            }
            this.test2Results.put(testName, key2Messages);
            ++i;
        }
    }

    public TestSummary(ResultInterface[] results) {
        this.test2Results = new HashMap();
        this.totals = new int[]{0, 0, 0};
        int i = 0;
        while (i < results.length) {
            int prio = results[i].getPriority();
            if (prio <= 3 && prio >= 1 && !MetricResult.isGlobalMetricResult(results[i])) {
                int[] previousResultCount;
                HashMap<String, int[]> key2Messages;
                String testName = results[i].getTestName();
                String msgKey = results[i].getErrorParameters().getProperty("__MSG_KEY");
                if (msgKey == null) {
                    msgKey = "";
                }
                if ((key2Messages = (HashMap<String, int[]>)this.test2Results.get(testName)) == null) {
                    key2Messages = new HashMap<String, int[]>();
                    this.test2Results.put(testName, key2Messages);
                }
                if ((previousResultCount = (int[])key2Messages.get(msgKey)) == null) {
                    previousResultCount = new int[3];
                    key2Messages.put(msgKey, previousResultCount);
                }
                switch (prio) {
                    case 1: {
                        previousResultCount[0] = previousResultCount[0] + 1;
                        this.totals[0] = this.totals[0] + 1;
                        break;
                    }
                    case 2: {
                        previousResultCount[1] = previousResultCount[1] + 1;
                        this.totals[1] = this.totals[1] + 1;
                        break;
                    }
                    case 3: {
                        previousResultCount[2] = previousResultCount[2] + 1;
                        this.totals[2] = this.totals[2] + 1;
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private TestSummary(Map test2Results, int[] totals) {
        this.test2Results = test2Results;
        this.totals = totals;
    }

    public String[] getTestNames() {
        return this.test2Results.keySet().toArray(new String[0]);
    }

    public int getErrorCountForTest(String testId) {
        Map key2Messages = (Map)this.test2Results.get(testId);
        if (key2Messages == null) {
            return 0;
        }
        int errors = 0;
        Iterator iter = key2Messages.values().iterator();
        while (iter.hasNext()) {
            int[] partialResults = (int[])iter.next();
            errors += partialResults[0];
        }
        return errors;
    }

    public int getErrorCountForTest(String testId, String msgId) {
        Map key2Messages = (Map)this.test2Results.get(testId);
        if (key2Messages == null) {
            return 0;
        }
        boolean errors = false;
        int[] messages = (int[])key2Messages.get(msgId);
        if (messages == null) {
            return 0;
        }
        return messages[0];
    }

    public int getWarningCountForTest(String testId) {
        Map key2Messages = (Map)this.test2Results.get(testId);
        if (key2Messages == null) {
            return 0;
        }
        int warnings = 0;
        Iterator iter = key2Messages.values().iterator();
        while (iter.hasNext()) {
            int[] partialResults = (int[])iter.next();
            warnings += partialResults[1];
        }
        return warnings;
    }

    public int getWarningCountForTest(String testId, String msgId) {
        Map key2Messages = (Map)this.test2Results.get(testId);
        if (key2Messages == null) {
            return 0;
        }
        boolean errors = false;
        int[] messages = (int[])key2Messages.get(msgId);
        if (messages == null) {
            return 0;
        }
        return messages[1];
    }

    public int getInfoCountForTest(String testId) {
        Map key2Messages = (Map)this.test2Results.get(testId);
        if (key2Messages == null) {
            return 0;
        }
        int infos = 0;
        Iterator iter = key2Messages.values().iterator();
        while (iter.hasNext()) {
            int[] partialResults = (int[])iter.next();
            infos += partialResults[2];
        }
        return infos;
    }

    public int getInfoCountForTest(String testId, String msgId) {
        Map key2Messages = (Map)this.test2Results.get(testId);
        if (key2Messages == null) {
            return 0;
        }
        boolean errors = false;
        int[] messages = (int[])key2Messages.get(msgId);
        if (messages == null) {
            return 0;
        }
        return messages[2];
    }

    public String[] getMessageKeys(String testName, boolean ignoreWarnings, boolean ignoreInfos) {
        HashSet<String> out = new HashSet<String>();
        Map key2Messages = (Map)this.test2Results.get(testName);
        if (key2Messages == null) {
            return new String[0];
        }
        Iterator iter = key2Messages.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (this.getMessageCount(testName, key, ignoreWarnings, ignoreInfos) <= 0) continue;
            out.add(key);
        }
        return out.toArray(new String[0]);
    }

    public int getMessageCount(String testName, String msgKey, boolean ignoreWarnings, boolean ignoreInfos) {
        Map key2Messages = (Map)this.test2Results.get(testName);
        if (key2Messages == null) {
            return 0;
        }
        int[] messages = (int[])key2Messages.get(msgKey);
        if (messages == null) {
            return 0;
        }
        int total = messages[0];
        if (!ignoreWarnings) {
            total += messages[1];
        }
        if (!ignoreInfos) {
            total += messages[2];
        }
        return total;
    }

    public int getTotalErrorCount() {
        return this.totals[0];
    }

    public int getTotalWarningCount() {
        return this.totals[1];
    }

    public int getTotalInfoCount() {
        return this.totals[2];
    }

    public static TestSummary merge(TestSummary[] toBeAdded) {
        HashMap test2Messages = new HashMap();
        int[] totals = new int[]{0, 0, 0};
        int i = 0;
        while (i < toBeAdded.length) {
            String[] testNames = toBeAdded[i].getTestNames();
            int j = 0;
            while (j < testNames.length) {
                HashMap<String, int[]> key2Messages = (HashMap<String, int[]>)test2Messages.get(testNames[j]);
                if (key2Messages == null) {
                    key2Messages = new HashMap<String, int[]>();
                    test2Messages.put(testNames[j], key2Messages);
                }
                Map mapToBeAdded = (Map)toBeAdded[i].test2Results.get(testNames[j]);
                Iterator iter = mapToBeAdded.keySet().iterator();
                while (iter.hasNext()) {
                    String msgKey = (String)iter.next();
                    int[] count = (int[])key2Messages.get(msgKey);
                    if (count == null) {
                        count = new int[]{0, 0, 0};
                        key2Messages.put(msgKey, count);
                    }
                    int[] messages = (int[])mapToBeAdded.get(msgKey);
                    int k = 0;
                    while (k < messages.length) {
                        int n = k;
                        count[n] = count[n] + messages[k];
                        int n2 = k;
                        totals[n2] = totals[n2] + messages[k];
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return new TestSummary(test2Messages, totals);
    }

    public StructureTree toStructureTree() {
        StructureTree tree = new StructureTree(new Header("TESTS"));
        Iterator iter = this.test2Results.keySet().iterator();
        while (iter.hasNext()) {
            String testName = (String)iter.next();
            Header testHeader = new Header("TEST");
            testHeader.setParameter("TEST_NAME", testName);
            StructureTree testTree = new StructureTree(testHeader);
            tree.addNewChild(testTree);
            Map key2Messages = (Map)this.test2Results.get(testName);
            Iterator iterator = key2Messages.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                int[] resultCount = (int[])key2Messages.get(key);
                Header keyHeader = new Header("MSG_KEY");
                keyHeader.setParameter("NAME", key);
                keyHeader.setParameter("ERRORS", Integer.toString(resultCount[0]));
                keyHeader.setParameter("WARNINGS", Integer.toString(resultCount[1]));
                keyHeader.setParameter("INFOS", Integer.toString(resultCount[2]));
                testTree.addNewChild(keyHeader);
            }
        }
        return tree;
    }
}

