/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.statistics;

import com.sap.tc.jtools.jlint.statistics.MetricSummary;
import com.sap.tc.jtools.jlint.statistics.TestSummary;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class ResultStatistics
implements Persistable {
    private MetricSummary metricResults;
    private TestSummary testSummary;

    public ResultStatistics(StructureTree tree) {
        this.metricResults = new MetricSummary(tree.getOnlyChild("METRICS"));
        this.testSummary = new TestSummary(tree.getOnlyChild("TESTS"));
    }

    public ResultStatistics(ResultInterface[] results) {
        this.testSummary = new TestSummary(results);
        this.metricResults = new MetricSummary(results);
    }

    public ResultStatistics(TestSummary ts, MetricSummary ms) {
        this.testSummary = ts;
        this.metricResults = ms;
    }

    public MetricSummary getMetricResult() {
        return this.metricResults;
    }

    public TestSummary getTestSummary() {
        return this.testSummary;
    }

    public static ResultStatistics merge(ResultStatistics[] toBeAdded) {
        TestSummary[] tss = new TestSummary[toBeAdded.length];
        MetricSummary[] mss = new MetricSummary[toBeAdded.length];
        int i = 0;
        while (i < toBeAdded.length) {
            tss[i] = toBeAdded[i].testSummary;
            mss[i] = toBeAdded[i].metricResults;
            ++i;
        }
        return new ResultStatistics(TestSummary.merge(tss), MetricSummary.merge(mss));
    }

    public StructureTree toStructureTree() {
        StructureTree tree = new StructureTree(new Header("STATISTICS"));
        tree.addChild(this.metricResults.toStructureTree());
        tree.addChild(this.testSummary.toStructureTree());
        return tree;
    }
}

