/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.statistics;

import com.sap.tc.jtools.jlint.statistics.MetricResult;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MetricSummary
implements Persistable {
    private MetricResult[] metricResults;

    public MetricSummary(StructureTree tree) {
        StructureTree[] children = tree.getChildren("METRIC_RESULT");
        this.metricResults = new MetricResult[children.length];
        int i = 0;
        while (i < children.length) {
            this.metricResults[i] = new MetricResult(children[i]);
            ++i;
        }
    }

    public MetricSummary(ResultInterface[] results) {
        ArrayList<MetricResult> metricResultList = new ArrayList<MetricResult>();
        int i = 0;
        while (i < results.length) {
            if (MetricResult.isGlobalMetricResult(results[i]) && results[i].getPriority() <= 3 && results[i].getPriority() >= 1) {
                MetricResult mr = new MetricResult(results[i]);
                metricResultList.add(mr);
            }
            ++i;
        }
        this.metricResults = metricResultList.toArray(new MetricResult[0]);
    }

    public MetricSummary(MetricResult[] metricResults) {
        this.metricResults = metricResults;
    }

    public MetricResult[] getMetricResults() {
        return this.metricResults;
    }

    public static MetricSummary merge(MetricSummary[] toBeAdded) {
        HashMap<String, ArrayList<MetricResult>> name2results = new HashMap<String, ArrayList<MetricResult>>();
        int i = 0;
        while (i < toBeAdded.length) {
            MetricResult[] mResults = toBeAdded[i].getMetricResults();
            int j = 0;
            while (j < mResults.length) {
                String mName = mResults[j].getTestName() + "$$" + mResults[j].getMetricName();
                ArrayList<MetricResult> mList = (ArrayList<MetricResult>)name2results.get(mName);
                if (mList == null) {
                    mList = new ArrayList<MetricResult>();
                    name2results.put(mName, mList);
                }
                mList.add(mResults[j]);
                ++j;
            }
            ++i;
        }
        ArrayList<MetricResult> mergedMetricList = new ArrayList<MetricResult>();
        Iterator iter = name2results.values().iterator();
        while (iter.hasNext()) {
            List mList = (List)iter.next();
            mergedMetricList.add(MetricResult.merge(mList.toArray(new MetricResult[0])));
        }
        MetricResult[] mergedResults = mergedMetricList.toArray(new MetricResult[0]);
        return new MetricSummary(mergedResults);
    }

    public StructureTree toStructureTree() {
        StructureTree tree = new StructureTree(new Header("METRICS"));
        int i = 0;
        while (i < this.metricResults.length) {
            tree.addChild(this.metricResults[i].toStructureTree());
            ++i;
        }
        return tree;
    }
}

