/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.statistics;

import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class MetricResult
implements Persistable {
    private static final int SUM = 1;
    private static final int AVERAGE = 2;
    private static final int MAX = 4;
    private static final int MIN = 8;
    private static final int STD_DEV = 16;
    private String testName;
    private String metricName;
    private int metricCode;
    private int count;
    private float sum;
    private float quadraticSum;
    private float max;
    private float min;

    public MetricResult(String testName, String metricName, int metricCode, int count, float sum, float quadraticSum, float max, float min) {
        this.testName = testName;
        this.metricCode = metricCode;
        this.metricName = metricName;
        this.count = count;
        this.sum = sum;
        this.quadraticSum = quadraticSum;
        this.max = max;
        this.min = min;
    }

    public MetricResult(StructureTree tree) {
        this.testName = tree.getParameter("TEST_NAME");
        this.metricName = tree.getParameter("METRIC_NAME");
        this.metricCode = Integer.parseInt(tree.getParameter("METRIC_CODE"));
        this.count = Integer.parseInt(tree.getParameter("COUNT"));
        this.sum = Float.parseFloat(tree.getParameter("SUM"));
        this.quadraticSum = Float.parseFloat(tree.getParameter("Q_SUM"));
        this.max = Float.parseFloat(tree.getParameter("MAX"));
        this.min = Float.parseFloat(tree.getParameter("MIN"));
    }

    public MetricResult(ResultInterface result) {
        this.testName = result.getTestName();
        this.metricName = result.getErrorParameters().getProperty("METRIC_NAME");
        this.metricCode = Integer.parseInt(result.getErrorParameters().getProperty("__MSG_KEY").substring("metric.".length()));
        this.count = Integer.parseInt(result.getErrorParameters().getProperty("COUNT"));
        this.sum = Float.parseFloat(result.getErrorParameters().getProperty("SUM"));
        this.quadraticSum = Float.parseFloat(result.getErrorParameters().getProperty("QUADRATIC_SUM"));
        this.max = Float.parseFloat(result.getErrorParameters().getProperty("MAX"));
        this.min = Float.parseFloat(result.getErrorParameters().getProperty("MIN"));
    }

    public boolean isSumDefined() {
        return (this.metricCode & 1) == 1;
    }

    public boolean isAverageDefined() {
        return (this.metricCode & 2) == 2;
    }

    public boolean isMaxDefined() {
        return (this.metricCode & 4) == 4;
    }

    public boolean isMinDefined() {
        return (this.metricCode & 8) == 8;
    }

    public boolean isStdDevDefined() {
        return (this.metricCode & 0x10) == 16;
    }

    public int getCount() {
        return this.count;
    }

    public float getMax() {
        return this.max;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public float getMin() {
        return this.min;
    }

    public float getQuadraticSum() {
        return this.quadraticSum;
    }

    public float getSum() {
        return this.sum;
    }

    public float getAverage() {
        return this.sum / (float)this.count;
    }

    public float getStdDev() {
        return (float)Math.sqrt((double)(this.quadraticSum / (float)this.count) - Math.pow(this.sum / (float)this.count, 2.0));
    }

    static MetricResult merge(MetricResult[] addenda) {
        if (addenda.length == 0) {
            throw new IllegalArgumentException("nothing to merge");
        }
        String testName = addenda[0].testName;
        String metricName = addenda[0].metricName;
        int metricCode = addenda[0].metricCode;
        int count = 0;
        float sum = 0.0f;
        float quadraticSum = 0.0f;
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < addenda.length) {
            count += addenda[i].count;
            sum += addenda[i].sum;
            quadraticSum += addenda[i].quadraticSum;
            if (max < addenda[i].max) {
                max = addenda[i].max;
            }
            if (min > addenda[i].min) {
                min = addenda[i].min;
            }
            ++i;
        }
        return new MetricResult(testName, metricName, metricCode, count, sum, quadraticSum, max, min);
    }

    public static boolean isMetricResult(ResultInterface result) {
        return result.getErrorParameters().getProperty("METRIC_NAME") != null;
    }

    public static boolean isGlobalMetricResult(ResultInterface result) {
        return MetricResult.isMetricResult(result) && result.getErrorParameters().getProperty("INTERNAL_DATA") != null && result.getErrorParameters().getProperty("INTERNAL_DATA").equals("true");
    }

    public StructureTree toStructureTree() {
        Header header = new Header("METRIC_RESULT");
        header.setParameter("TEST_NAME", this.testName);
        header.setParameter("METRIC_NAME", this.metricName);
        header.setParameter("METRIC_CODE", Integer.toString(this.metricCode));
        header.setParameter("COUNT", Integer.toString(this.count));
        header.setParameter("SUM", Float.toString(this.sum));
        header.setParameter("Q_SUM", Float.toString(this.quadraticSum));
        header.setParameter("MAX", Float.toString(this.max));
        header.setParameter("MIN", Float.toString(this.min));
        StructureTree tree = new StructureTree(header);
        return tree;
    }
}

