/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.html.Page;
import com.sap.tc.jtools.jlint.report.html.RunReportPageManager;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import java.io.Serializable;

public class TestDescriptionPage
extends Page {
    private TestDescriptionSet data;
    private String contents;

    public TestDescriptionPage(TestDescriptionSet tests, String address, RunReportPageManager manager) {
        super(address, manager);
        this.data = tests;
    }

    public String getContents() {
        if (this.contents == null) {
            StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"><html> <head> <META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><title>");
            sb.append("Test set " + this.data.getName() + " (version " + this.data.getVersion() + ")");
            sb.append("</title></head>");
            sb.append("<body style=\"font-family: arial;\"><h2>");
            sb.append("Test set " + this.data.getName() + " (version " + this.data.getVersion() + ")");
            sb.append("</h2>");
            sb.append("<hr><p>");
            sb.append("<table border=\"1\"><tr><th>Category</th><th>Testname</th><th>Responsible</th><th>Version</th><th>Description</th></tr>");
            TestTree topTree = this.data.getTestTree();
            sb.append(this.getTableContent(topTree, ""));
            sb.append("</table>");
            sb.append(this.getDescriptionContent(topTree, ""));
            sb.append("</body></html>");
            this.contents = sb.toString();
        }
        return this.contents;
    }

    private String getDescriptionContent(TestTree tree, String parentCategory) {
        StringBuffer sb = new StringBuffer();
        String category = parentCategory + "/" + tree.getName();
        TestTreeNode[] nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.length) {
            switch (nodes[i].getNodeType()) {
                case 2: {
                    sb.append(this.getDescriptionContent((TestTree)nodes[i], category));
                    break;
                }
                case 1: {
                    sb.append(this.getTestDescriptionContent((TestDescriptionInterface)nodes[i], category));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String getTestDescriptionContent(TestDescriptionInterface test, String category) {
        StringBuffer sb = new StringBuffer();
        sb.append("<h3><a name=\"" + test.getName() + "\"></a>" + test.getName() + "</h3>");
        sb.append("<dl>");
        sb.append("<dt>Responsible</dt>");
        sb.append("<dd>" + test.getTestResponsible() + "</dd><p>");
        sb.append("<dt>Version</dt>");
        sb.append("<dd>" + test.getVersion() + "</dd><p>");
        sb.append("<dt>Description</dt>");
        sb.append("<dd><pre>" + test.getDescription() + "</pre></dd>");
        String pseudoComment = TestDescriptionPage.getPseudoComment(test);
        sb.append("<dt>Disabling Pseudocomment</dt>");
        if (pseudoComment != null) {
            sb.append("<dd>This test may be disabled using the pseudo-comment <tt>" + pseudoComment + "</tt></dd><p>");
        } else {
            sb.append("<dd>None</dd><p>");
        }
        sb.append("<dt>Messages</dt>");
        sb.append("<dd><p>");
        ITestMessageDescription[] messages = test.getMessages();
        if (messages.length == 0) {
            sb.append("none");
        } else {
            sb.append("<table border=\"1\"><tr><th>Message</th><th>Prio</th></tr>");
            int i = 0;
            while (i < messages.length) {
                sb.append("<tr><td>" + messages[i].getDisplayName() + "</td>");
                int prio = messages[i].getPriority();
                sb.append("<td>" + (prio == -1 ? "dynamic" : Integer.toString(prio)) + "</td></tr>");
                ++i;
            }
            sb.append("</table>");
        }
        sb.append("<dd>");
        sb.append("<p><dt>Parameters</dt>");
        ParameterInterface[] params = test.getInputParameters();
        sb.append("<dd><p>");
        if (params.length == 0) {
            sb.append("none");
        } else {
            sb.append("<table border=\"1\"><tr><th>Name</th><th>Type</th><th>Default value</th></tr>");
            int i = 0;
            while (i < params.length) {
                sb.append("<tr><td>" + params[i].getName() + "</td>");
                sb.append("<td>" + params[i].getType() + "</td>");
                Serializable value = params[i].getValue();
                sb.append("<td>" + (value == null ? "" : value.toString()) + "</td></tr>");
                ++i;
            }
            sb.append("</table>");
        }
        sb.append("</dd></dl><p><p>");
        return sb.toString();
    }

    private static String getPseudoComment(TestDescriptionInterface test) {
        ParameterInterface pseudoComment = test.getInternalParameter("PSEUDO_COMMENT_SUFFIX");
        if (pseudoComment != null) {
            return "//$JL-" + ((String)((Object)pseudoComment.getValue())).trim().toUpperCase() + "$";
        }
        return null;
    }

    private String getTableContent(TestTree tree, String parentCategory) {
        StringBuffer sb = new StringBuffer();
        String category = parentCategory + "/" + tree.getName();
        TestTreeNode[] nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.length) {
            switch (nodes[i].getNodeType()) {
                case 2: {
                    sb.append(this.getTableContent((TestTree)nodes[i], category));
                    break;
                }
                case 1: {
                    sb.append(this.getTestContent((TestDescriptionInterface)nodes[i], category));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String getTestContent(TestDescriptionInterface test, String category) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr><td>" + category + "</td>");
        sb.append("<td>" + test.getName() + "</td>");
        sb.append("<td>" + test.getTestResponsible() + "</td>");
        sb.append("<td>" + test.getVersion() + "</td>");
        sb.append("<td><a href=\"#" + test.getName() + "\">Description</a></td>");
        sb.append("</tr>");
        return sb.toString();
    }
}

