/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.html.RunFilterInterface;
import com.sap.tc.jtools.jlint.report.html.RunReportConfiguration;
import com.sap.tc.jtools.util.structures.StructureTree;

public class ReportConfiguration {
    private static final RunFilterInterface DEFAULT_RUN_FILTER = new RunFilterInterface(){

        public boolean acceptRun(String runId) {
            return true;
        }
    };
    private String title = "JLin Report";
    private String description = "";
    private RunFilterInterface runFilter = DEFAULT_RUN_FILTER;
    private boolean displayTotalCountHistory = true;
    private boolean displayCountPerClassHistory = false;
    private boolean displayCountPerLocHistory = true;
    private boolean displayTestCountHistory = true;
    private boolean displayHistoryForMsg = true;
    private int maxMsgKeyNumber = 4;
    private RunReportConfiguration rrc = new RunReportConfiguration();

    public ReportConfiguration() {
    }

    public ReportConfiguration(StructureTree tree) {
        StructureTree runFilterTree;
        StructureTree runConfigurationTree;
        this.title = tree.getOnlyChild("TITLE").getText();
        this.description = tree.getOnlyChild("DESCRIPTION").getText();
        if (tree.getParameter("DISPLAY_TOTAL_COUNT_HISTORY") != null) {
            this.displayTotalCountHistory = new Boolean(tree.getParameter("DISPLAY_TOTAL_COUNT_HISTORY"));
        }
        if (tree.getParameter("DISPLAY_COUNT_PER_CLASS_HISTORY") != null) {
            this.displayCountPerClassHistory = new Boolean(tree.getParameter("DISPLAY_COUNT_PER_CLASS_HISTORY"));
        }
        if (tree.getParameter("DISPLAY_COUNT_PER_LOC_HISTORY") != null) {
            this.displayCountPerLocHistory = new Boolean(tree.getParameter("DISPLAY_COUNT_PER_LOC_HISTORY"));
        }
        if (tree.getParameter("DISPLAY_TEST_COUNT_HISTORY") != null) {
            this.displayTestCountHistory = new Boolean(tree.getParameter("DISPLAY_TEST_COUNT_HISTORY"));
        }
        if (tree.getParameter("DISPLAY_HISTORY_FOR_MSG") != null) {
            this.displayHistoryForMsg = new Boolean(tree.getParameter("DISPLAY_HISTORY_FOR_MSG"));
            if (this.displayHistoryForMsg && tree.getParameter("MAX_MSG_KEY_NUMBER") != null) {
                this.maxMsgKeyNumber = Integer.parseInt(tree.getParameter("MAX_MSG_KEY_NUMBER"));
            }
        }
        if ((runConfigurationTree = tree.getOnlyChild("RUN_CONFIGURATION")) != null) {
            this.rrc = new RunReportConfiguration(runConfigurationTree);
        }
        if ((runFilterTree = tree.getOnlyChild("RUN_FILTER")) != null) {
            StructureTree[] runNameTrees = runFilterTree.getChildren("RUN");
            final String[] runNames = new String[runNameTrees.length];
            int i = 0;
            while (i < runNames.length) {
                runNames[i] = runNameTrees[i].getParameter("ID");
                ++i;
            }
            this.runFilter = new RunFilterInterface(){

                public boolean acceptRun(String runId) {
                    int i = 0;
                    while (i < runNames.length) {
                        if (runNames[i].equals(runId)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            };
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDisplayCountPerClassHistory() {
        return this.displayCountPerClassHistory;
    }

    public boolean isDisplayCountPerLocHistory() {
        return this.displayCountPerLocHistory;
    }

    public boolean isDisplayHistoryForMsg() {
        return this.displayHistoryForMsg;
    }

    public boolean isDisplayTestCountHistory() {
        return this.displayTestCountHistory;
    }

    public boolean isDisplayTotalCountHistory() {
        return this.displayTotalCountHistory;
    }

    public int getMaxMsgKeyNumber() {
        return this.maxMsgKeyNumber;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDisplayCountPerClassHistory(boolean b) {
        this.displayCountPerClassHistory = b;
    }

    public void setDisplayCountPerLocHistory(boolean b) {
        this.displayCountPerLocHistory = b;
    }

    public void setDisplayHistoryForMsg(boolean b) {
        this.displayHistoryForMsg = b;
    }

    public void setDisplayTestCountHistory(boolean b) {
        this.displayTestCountHistory = b;
    }

    public void setDisplayTotalCountHistory(boolean b) {
        this.displayTotalCountHistory = b;
    }

    public void setMaxMsgKeyNumber(int i) {
        this.maxMsgKeyNumber = i;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public RunFilterInterface getRunFilter() {
        return this.runFilter;
    }

    public void setRunFilter(RunFilterInterface interface1) {
        this.runFilter = interface1;
    }

    public RunReportConfiguration getRunReportConfiguration() {
        return this.rrc;
    }

    public void setRunReportConfiguration(RunReportConfiguration configuration) {
        this.rrc = configuration;
    }
}

