/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.html.Page;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PageManager {
    protected static final String PROJECT_DIRECTORY = "projects";
    protected static final String TEST_DIRECTORY = "tests";
    protected static final String VARIANT_DIRECTORY = "variants";
    protected List allPages = new ArrayList();
    protected File rootDirectory;

    public PageManager(String rootDirectoryPath, boolean cleanUp) {
        this.rootDirectory = new File(rootDirectoryPath);
        if (this.rootDirectory.exists() && cleanUp) {
            this.cleanUp(this.rootDirectory);
        }
        this.rootDirectory.mkdirs();
    }

    public void saveAll() {
        Iterator iter = this.allPages.iterator();
        while (iter.hasNext()) {
            try {
                Page page = (Page)iter.next();
                String content = page.getContents();
                File file = new File(this.rootDirectory, page.getAddress());
                file.getParentFile().mkdirs();
                FileWriter fr = new FileWriter(file);
                fr.write(content);
                fr.flush();
                fr.close();
                iter.remove();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void cleanUp(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            int i = 0;
            while (i < children.length) {
                this.cleanUp(children[i]);
                ++i;
            }
        }
        f.delete();
    }

    protected String getRelativeLink(String link, String relativeTo) {
        if (link == null | link.trim().equals("")) {
            return null;
        }
        StringTokenizer linkTokens = new StringTokenizer(link.replace('\\', '/'), "/");
        StringTokenizer relativeToTokens = new StringTokenizer(relativeTo.replace('\\', '/'), "/");
        if (link.equals(relativeTo)) {
            String out = "";
            while (linkTokens.hasMoreTokens()) {
                out = linkTokens.nextToken();
            }
            if (out == null || out.trim().equals("")) {
                return null;
            }
            return out;
        }
        return this.getRelativeLink(linkTokens, relativeToTokens);
    }

    private String getRelativeLink(StringTokenizer linkTokens, StringTokenizer relativeToTokens) {
        String relativeToToken;
        String linkToken = linkTokens.nextToken();
        if (linkToken.equals(relativeToToken = relativeToTokens.nextToken())) {
            return this.getRelativeLink(linkTokens, relativeToTokens);
        }
        String out = "";
        int i = 0;
        while (i < relativeToTokens.countTokens()) {
            out = out + "../";
            ++i;
        }
        out = out + linkToken;
        while (linkTokens.hasMoreTokens()) {
            out = out + "/" + linkTokens.nextToken();
        }
        return out;
    }
}

