/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ff.impl.ProjectRun;
import com.sap.tc.jtools.jlint.report.html.ProjectFilterInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;

public class Run
implements RunInterface {
    private File runDir;
    private ProjectRunInterface[] projects;
    private ResultStatistics globalResults;
    private TestDescriptionSet[] testDescriptionSets;

    public Run(File runDir) {
        this.runDir = runDir;
        File testDirectory = new File(runDir, "jlin_settings/tests");
        File[] testDescriptorFiles = testDirectory.listFiles();
        ArrayList<TestDescriptionSet> testDescriptionList = new ArrayList<TestDescriptionSet>();
        int i = 0;
        while (i < testDescriptorFiles.length) {
            try {
                testDescriptionList.add(new TestDescriptionSet(XMLTool.parseReader((Reader)new FileReader(testDescriptorFiles[i]))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.testDescriptionSets = testDescriptionList.toArray(new TestDescriptionSet[testDescriptorFiles.length]);
        ArrayList projectList = new ArrayList();
        File[] projectDirectories = runDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals("jlin_settings");
            }
        });
        this.projects = new ProjectRunInterface[projectDirectories.length];
        TestSet defaultVariant = null;
        try {
            defaultVariant = new TestSet(XMLTool.parseReader((Reader)new FileReader(new File(runDir, "jlin_settings/variants/testconfig.xml"))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i2 = 0;
        while (i2 < projectDirectories.length) {
            TestSet variant = defaultVariant;
            File projectVariant = new File(projectDirectories[i2], "jlin_settings/variants/testconfig.xml");
            if (projectVariant.exists()) {
                try {
                    variant = new TestSet(XMLTool.parseReader((Reader)new FileReader(projectVariant)));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            this.projects[i2] = new ProjectRun(projectDirectories[i2].getName(), this.getRunID(), variant, projectDirectories[i2]);
            ++i2;
        }
    }

    public String getRunID() {
        return this.runDir.getName();
    }

    public ResultStatistics getGlobalResults() {
        return this.getGlobalResults(null);
    }

    public ResultStatistics getGlobalResults(ProjectFilterInterface projectFilter) {
        if (this.globalResults == null) {
            ResultStatistics[] projectStats = new ResultStatistics[this.projects.length];
            ArrayList<ResultStatistics> projectStatList = new ArrayList<ResultStatistics>();
            int i = 0;
            while (i < this.projects.length) {
                if (this.projects[i] != null && this.projects[i].getResults() != null && (projectFilter == null || projectFilter.acceptProject(this.projects[i].getProjectId()))) {
                    projectStatList.add(this.projects[i].getStatistics());
                }
                ++i;
            }
            this.globalResults = ResultStatistics.merge(projectStatList.toArray(new ResultStatistics[0]));
        }
        return this.globalResults;
    }

    public ProjectRunInterface[] getProjectsRuns() {
        return this.projects;
    }

    public TestDescriptionSet[] getTestDescriptionSets() {
        return this.testDescriptionSets;
    }

    public ProjectRunSummaryInterface[] getProjectSummaries() {
        return this.projects;
    }

    public String getRunRootDirectory() {
        return this.runDir.getAbsolutePath();
    }
}

