/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.i18n;

import com.sap.tc.jtools.jlint.extension.Module;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jlint.extension.TestSet;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResultLocalizer {
    private Map testName2BundleMap = new HashMap();
    private static final String PARAMETER_PREFIX = "{";
    private static final String PARAMETER_SUFFIX = "}";
    private static final String MISSING_RESOURCEBUNDLE_MARKER = "!!";
    private static final String MISSING_RESOURCE_MARKER = "!";

    public ResultLocalizer(TestProviderInterface testProvider) {
        Module[] modules = testProvider.getModules();
        int i = 0;
        while (i < modules.length) {
            TestSet[] testSets = modules[i].getTestSets();
            int j = 0;
            while (j < testSets.length) {
                TestTree testTree = testSets[j].getTestDescriptionSet().getTestTree();
                this.descendTree(testTree, testSets[j].getLoader(), null);
                ++j;
            }
            ++i;
        }
    }

    private void descendTree(TestTree testTree, ClassLoader loader, String parentResBundle) {
        TestTreeNode[] children = testTree.getNodes();
        int i = 0;
        while (i < children.length) {
            if (children[i].getNodeType() == 2) {
                String resBundle = this.readResourceBundle((TestTree)children[i], loader, parentResBundle);
                this.descendTree((TestTree)children[i], loader, resBundle);
            }
            ++i;
        }
    }

    private String readResourceBundle(TestTree tree, ClassLoader loader, String parentResBundle) {
        String descrResBundle = tree.getResourceBundle();
        if (descrResBundle == null) {
            descrResBundle = parentResBundle;
        }
        TestDescriptionInterface[] tests = tree.getAllLeaves();
        int j = 0;
        while (j < tests.length) {
            String testName = tests[j].getName();
            String testResBundle = tests[j].getResourceBundle();
            String bundleName = null;
            if (testResBundle != null) {
                bundleName = testResBundle;
            } else if (descrResBundle != null) {
                bundleName = descrResBundle;
            }
            if (bundleName != null) {
                ResourceBundle resBundle = null;
                try {
                    resBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
                }
                catch (MissingResourceException e) {
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
                if (resBundle != null) {
                    this.testName2BundleMap.put(testName, resBundle);
                }
            }
            ++j;
        }
        return descrResBundle;
    }

    public ResultInterface[] localize(ResultInterface[] results) {
        String value = null;
        int i = 0;
        while (i < results.length) {
            block13: {
                ResourceBundle bundle;
                Properties msgProps = results[i].getErrorParameters();
                String key = msgProps.getProperty("__MSG_KEY");
                String errorText = results[i].getErrorText().trim();
                if (key == null) {
                    key = errorText;
                }
                if ((bundle = (ResourceBundle)this.testName2BundleMap.get(results[i].getTestName())) == null) {
                    if ("".equals(errorText)) {
                        results[i].setErrorText(MISSING_RESOURCEBUNDLE_MARKER + key + MISSING_RESOURCEBUNDLE_MARKER);
                    }
                } else {
                    try {
                        value = bundle.getString(key);
                    }
                    catch (MissingResourceException e) {
                        if ("".equals(errorText)) {
                            results[i].setErrorText(MISSING_RESOURCE_MARKER + key + MISSING_RESOURCE_MARKER);
                        }
                        break block13;
                    }
                    catch (NullPointerException npe) {
                        if ("".equals(errorText)) {
                            results[i].setErrorText(MISSING_RESOURCE_MARKER + key + MISSING_RESOURCE_MARKER);
                        }
                        break block13;
                    }
                    if (((Hashtable)msgProps).size() == 1) {
                        results[i].setErrorText(value);
                    } else {
                        StringBuffer buf = new StringBuffer(value);
                        Enumeration en = ((Hashtable)msgProps).keys();
                        while (en.hasMoreElements()) {
                            String propKey = (String)en.nextElement();
                            ResultLocalizer.replaceOccurences(buf, PARAMETER_PREFIX + propKey + PARAMETER_SUFFIX, msgProps.getProperty(propKey));
                        }
                        results[i].setErrorText(buf.toString());
                    }
                }
            }
            ++i;
        }
        return results;
    }

    private static void replaceOccurences(StringBuffer buf, String original, String replacement) {
        String str = buf.toString();
        int origLen = original.length();
        int diff = replacement.length() - origLen;
        int curIndex = 0;
        int i = 0;
        while (curIndex != -1) {
            curIndex = str.indexOf(original, i == 0 ? 0 : curIndex + origLen);
            if (curIndex != -1) {
                int correctedPos = curIndex + i * diff;
                buf.replace(correctedPos, correctedPos + origLen, replacement);
            }
            ++i;
        }
    }
}

