/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.extension;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.extension.JarClassLoader;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class TestSet {
    private static final String TEST_SET_TAG = "testSet";
    private static final String LIB_TAG = "library";
    private static final String DESCR_TAG = "descriptorFile";
    private static final String PATH_ATTR = "path";
    protected ClassLoader loader;
    protected TestDescriptionSet descriptor;

    public TestSet(File descriptorFile, ClassLoader loader) throws BadTreeException, XMLParseException, IOException {
        if (!descriptorFile.isFile()) {
            throw new FileNotFoundException("descriptor " + descriptorFile.getAbsolutePath() + " not found!");
        }
        this.descriptor = new TestDescriptionSet(descriptorFile);
        this.loader = loader;
    }

    public TestSet(StructureTree testSet, ClassLoader parent) throws BadTreeException, IOException, XMLParseException {
        if (!TEST_SET_TAG.equals(testSet.getTag())) {
            throw new BadTreeException();
        }
        this.descriptor = new TestDescriptionSet(new File(testSet.getParameter(DESCR_TAG)));
        StructureTree[] libs = testSet.getChildren(LIB_TAG);
        ArrayList<File> jars = new ArrayList<File>();
        int i = 0;
        while (i < libs.length) {
            jars.add(new File(libs[i].getParameter(PATH_ATTR)));
            ++i;
        }
        this.loader = new JarClassLoader(parent, jars.toArray(new File[0]));
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public TestDescriptionSet getTestDescriptionSet() {
        return this.descriptor;
    }
}

