/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.extension;

import com.sap.tc.jtools.jlint.extension.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ModuleClassLoader
extends JarClassLoader {
    private ClassLoader[] requiredClassLoaders;

    public ModuleClassLoader(ClassLoader parent, File[] libs, ClassLoader[] requiredClassLoaders) throws IOException {
        super(parent, libs);
        this.requiredClassLoaders = requiredClassLoaders;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            c = null;
        }
        if (c != null) {
            return c;
        }
        int i = 0;
        while (i < this.requiredClassLoaders.length) {
            try {
                c = this.requiredClassLoaders[i].loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c != null) {
                return c;
            }
            ++i;
        }
        throw new ClassNotFoundException(name);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        int i = 0;
        while (i < this.requiredClassLoaders.length) {
            stream = this.requiredClassLoaders[i].getResourceAsStream(name);
            if (stream != null) {
                return stream;
            }
            ++i;
        }
        return null;
    }
}

