/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.extension;

import com.sap.tc.jtools.jlint.extension.ModuleClassLoader;
import com.sap.tc.jtools.jlint.extension.TestSet;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Module {
    private static final String MODULE_TAG = "module";
    private static final String ID_ATTR = "id";
    private static final String DEPENDS_ATTR = "depends";
    private static final String PATH_ATTR = "path";
    private static final String NAME_ATTR = "name";
    private static final String CLASS_ATTR = "class";
    private static final String LIB_TAG = "library";
    private static final String TESTSET_TAG = "testSet";
    private static final String TESTOBJECT_TYPE_TAG = "testObjectType";
    private String id;
    private ClassLoader moduleClassLoader;
    private List testSets = new ArrayList();
    private Map name2testObjectClassnameMap = new HashMap();

    public Module(StructureTree moduleTree, ClassLoader parent, Map id2ModuleMap) throws BadTreeException, IOException, XMLParseException {
        if (!MODULE_TAG.equals(moduleTree.getTag())) {
            throw new BadTreeException();
        }
        this.id = moduleTree.getParameter(ID_ATTR);
        String reqModIds = moduleTree.getParameter(DEPENDS_ATTR);
        ArrayList<ClassLoader> reqClassLoaders = new ArrayList<ClassLoader>();
        if (reqModIds != null) {
            StringTokenizer tok = new StringTokenizer(reqModIds, ",", false);
            while (tok.hasMoreElements()) {
                Module mod = (Module)id2ModuleMap.get(tok.nextToken().trim());
                reqClassLoaders.add(mod.moduleClassLoader);
            }
        }
        StructureTree[] libTrees = moduleTree.getChildren(LIB_TAG);
        ArrayList<File> libs = new ArrayList<File>();
        int i = 0;
        while (i < libTrees.length) {
            libs.add(new File(libTrees[i].getParameter(PATH_ATTR)));
            ++i;
        }
        this.moduleClassLoader = new ModuleClassLoader(parent, libs.toArray(new File[0]), reqClassLoaders.toArray(new ClassLoader[0]));
        StructureTree[] testObjTypes = moduleTree.getChildren(TESTOBJECT_TYPE_TAG);
        int i2 = 0;
        while (i2 < testObjTypes.length) {
            String name = testObjTypes[i2].getParameter(NAME_ATTR);
            String className = testObjTypes[i2].getParameter(CLASS_ATTR);
            this.name2testObjectClassnameMap.put(name, className);
            ++i2;
        }
        StructureTree[] testSetTrees = moduleTree.getChildren(TESTSET_TAG);
        int i3 = 0;
        while (i3 < testSetTrees.length) {
            this.testSets.add(new TestSet(testSetTrees[i3], this.moduleClassLoader));
            ++i3;
        }
    }

    protected Module(String id, ClassLoader moduleLoader, Map name2testObjClassName) {
        this.id = id;
        this.moduleClassLoader = moduleLoader;
        this.name2testObjectClassnameMap = name2testObjClassName;
    }

    public Class loadTestClass(String className) throws ClassNotFoundException {
        Iterator iter = this.testSets.iterator();
        while (iter.hasNext()) {
            TestSet testSet = (TestSet)iter.next();
            try {
                Class<?> c = testSet.getLoader().loadClass(className);
                return c;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(className);
    }

    public TestSet[] getTestSets() {
        TestSet[] out = new TestSet[this.testSets.size()];
        int i = 0;
        while (i < out.length) {
            out[i] = (TestSet)this.testSets.get(i);
            ++i;
        }
        return out;
    }

    public TestObject getTestObject(StructureTree tree) throws InvalidTestObjectSpecification {
        String name = tree.getParameter("TYPE");
        Class c = this.getTestObjectClass(name);
        if (c == null) {
            return null;
        }
        try {
            Constructor constructor = c.getConstructor(this.moduleClassLoader.loadClass("com.sap.tc.jtools.util.structures.StructureTree"));
            if (constructor == null) {
                throw new InvalidTestObjectSpecification("missing constructor: " + c.getName());
            }
            return (TestObject)constructor.newInstance(tree);
        }
        catch (Exception e) {
            throw new InvalidTestObjectSpecification(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean hasTest(String testName) {
        Iterator iter = this.testSets.iterator();
        while (iter.hasNext()) {
            TestSet testSet = (TestSet)iter.next();
            TestDescriptionInterface[] tests = testSet.getTestDescriptionSet().getTestTree().getAllLeaves();
            int j = 0;
            while (j < tests.length) {
                if (testName.equals(tests[j].getName())) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public void addTestSet(TestSet testSet) {
        this.testSets.add(testSet);
    }

    public TestObjectPosition getTestObjectPosition(String testObjectType, StructureTree positionTree) throws InvalidTestObjectSpecification {
        try {
            Class c = this.getTestObjectClass(testObjectType);
            if (c == null) {
                return null;
            }
            return (TestObjectPosition)c.getMethod("getPosition", this.moduleClassLoader.loadClass("com.sap.tc.jtools.util.structures.StructureTree")).invoke(null, positionTree);
        }
        catch (Exception e) {
            throw new InvalidTestObjectSpecification(e);
        }
    }

    private Class getTestObjectClass(String testObjectType) throws InvalidTestObjectSpecification {
        String className = (String)this.name2testObjectClassnameMap.get(testObjectType);
        if (className == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = this.moduleClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (c == null) {
            throw new InvalidTestObjectSpecification("class " + className + " does not exist");
        }
        return c;
    }
}

