/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;

public class TestDescriptionSet
implements Persistable {
    private static final String CUR_DIR_MACRO = "CURRENT_DIRECTORY";
    private static final String PARAMETER_TAG_TOOL_DESCRIPTOR = "TOOL_DESCRIPTOR";
    private static final String TOOL_VERSION = "VERSION";
    private static final String TOOL_NAME = "NAME";
    private int version;
    private String name;
    private TestTree testTree;

    public TestDescriptionSet(String name, int version, TestTree testTree) {
        this.version = version;
        this.name = name;
        this.testTree = testTree;
    }

    public TestDescriptionSet(File file) throws IOException, XMLParseException, BadTreeException {
        StructureTree testTree = XMLTool.parseReader((Reader)new BufferedReader(new FileReader(file)));
        Properties macros = new Properties();
        macros.setProperty(CUR_DIR_MACRO, file.getParentFile().getAbsolutePath());
        testTree.resolveMacros(macros);
        this.init(testTree);
    }

    private void init(StructureTree tree) throws BadTreeException {
        try {
            this.name = tree.getParameter(TOOL_NAME);
            this.version = Integer.parseInt(tree.getParameter(TOOL_VERSION));
            this.testTree = new TestTree(tree.getChildren()[0]);
        }
        catch (Exception e) {
            throw new BadTreeException(e);
        }
    }

    public TestDescriptionSet(StructureTree tree) throws BadTreeException {
        this.init(tree);
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public TestTree getTestTree() {
        try {
            return new TestTree(this.testTree.toStructureTree());
        }
        catch (BadTreeException e) {
            return null;
        }
    }

    public StructureTree toStructureTree() {
        Header header = new Header(PARAMETER_TAG_TOOL_DESCRIPTOR);
        header.setParameter(TOOL_NAME, this.name);
        header.setParameter(TOOL_VERSION, String.valueOf(this.version));
        StructureTree st = new StructureTree(header);
        st.addChild(this.testTree.toStructureTree());
        return st;
    }
}

