/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.TestMessageDescription;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;

public class TestDefinition
implements TestDescriptionInterface {
    private static final String TEST_RESPONSIBLE = "RESPONSIBLE";
    private static final String TEST_DESCRIPTION = "DESCRIPTION";
    private static final String TEST_SIGNATURE = "SIGNATURE";
    private static final String TEST_INTERNAL_PARAMETERS = "INTERNAL_PARAMETERS";
    private static final String TEST_TEST_OBJECT_TYPE = "TEST_OBJECT_TYPE";
    private static final String TEST_LABEL = "LABEL";
    private static final String TEST_VERSION = "VERSION";
    public static final String PARAMETER_TEST_CLASS = "TEST_CLASS";
    public static final String PARAMETER_RESOURCE_BUNDLE = "RESOURCE_BUNDLE";
    private ParameterInterface[] internalParameters;
    private String objectType;
    private String name;
    private String description;
    private String testResponsible;
    private String version;
    private String testClass;
    private String resourceBundle;
    private ParameterInterface[] inputParameters;
    private ITestMessageDescription[] messages;

    public TestDefinition(String name, String description, String testResponsible, String resourceBundle, String version, ParameterInterface[] internalParameters, String objectType, ParameterInterface[] inputParameters, ITestMessageDescription[] messages) throws BadTreeException {
        this.name = name;
        this.description = description;
        this.testResponsible = testResponsible;
        this.resourceBundle = resourceBundle;
        this.version = version;
        this.objectType = objectType;
        this.messages = messages;
        this.inputParameters = inputParameters == null ? new ParameterInterface[0] : inputParameters;
        try {
            this.internalParameters = internalParameters;
            int i = 0;
            while (i < internalParameters.length) {
                if (internalParameters[i].getName().equals(PARAMETER_TEST_CLASS)) {
                    this.testClass = (String)((Object)internalParameters[i].getValue());
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new BadTreeException(e);
        }
    }

    public TestDefinition(StructureTree tree) throws BadTreeException {
        int i;
        this.name = tree.getParameter(TEST_LABEL);
        this.resourceBundle = tree.getParameter(PARAMETER_RESOURCE_BUNDLE);
        this.testResponsible = tree.getParameter(TEST_RESPONSIBLE);
        this.description = tree.getOnlyChild(TEST_DESCRIPTION).getText();
        this.version = tree.getParameter(TEST_VERSION);
        if (tree.getChildren(TEST_INTERNAL_PARAMETERS).length > 0) {
            StructureTree parTree = tree.getOnlyChild(TEST_INTERNAL_PARAMETERS);
            StructureTree[] internalParams = parTree.getChildren();
            this.internalParameters = new ParameterInterface[internalParams.length];
            i = 0;
            while (i < this.internalParameters.length) {
                this.internalParameters[i] = ParameterTool.createParameter(internalParams[i].getTag(), "STRING", internalParams[i].getText());
                if (this.internalParameters[i].getName().equals(PARAMETER_TEST_CLASS)) {
                    this.testClass = (String)((Object)this.internalParameters[i].getValue());
                }
                ++i;
            }
        }
        this.objectType = tree.getOnlyChild(TEST_TEST_OBJECT_TYPE).getText();
        try {
            StructureTree[] parameterTrees = tree.getOnlyChild(TEST_SIGNATURE).getChildren("INPUT_PARAMETER");
            ParameterInterface[] out = new ParameterInterface[parameterTrees.length];
            i = 0;
            while (i < out.length) {
                out[i] = ParameterTool.createParameter(parameterTrees[i]);
                ++i;
            }
            this.inputParameters = out;
        }
        catch (Exception e) {
            this.inputParameters = new ParameterInterface[0];
        }
        StructureTree msgs = tree.getOnlyChild("MESSAGES");
        if (msgs != null) {
            StructureTree[] msgTrees = msgs.getChildren("MESSAGE");
            ArrayList<TestMessageDescription> msgList = new ArrayList<TestMessageDescription>(msgTrees.length);
            int i2 = 0;
            while (i2 < msgTrees.length) {
                msgList.add(TestMessageDescription.fromStructureTree(msgTrees[i2]));
                ++i2;
            }
            this.messages = msgList.toArray(new ITestMessageDescription[0]);
        } else {
            this.messages = new ITestMessageDescription[0];
        }
    }

    public StructureTree toStructureTree() {
        Header header = new Header("TEST");
        header.setParameter(TEST_LABEL, this.getName());
        if (this.resourceBundle != null) {
            header.setParameter(PARAMETER_RESOURCE_BUNDLE, this.resourceBundle);
        }
        header.setParameter(TEST_RESPONSIBLE, this.getTestResponsible());
        header.setParameter(TEST_VERSION, this.getVersion());
        StructureTree tree = new StructureTree(header);
        StructureTree descriptionTree = new StructureTree(new Header(TEST_DESCRIPTION));
        descriptionTree.setText(this.getDescription());
        tree.addChild(descriptionTree);
        StructureTree testObjectTree = new StructureTree(new Header(TEST_TEST_OBJECT_TYPE));
        testObjectTree.setText(this.objectType);
        tree.addChild(testObjectTree);
        tree.addChild(this.getInternalParameterTree());
        StructureTree signatureTree = new StructureTree(new Header(TEST_SIGNATURE));
        ParameterInterface[] inputParameters = this.getInputParameters();
        int i = 0;
        while (i < inputParameters.length) {
            signatureTree.addChild(inputParameters[i].toStructureTree());
            ++i;
        }
        tree.addChild(signatureTree);
        StructureTree msgsTree = new StructureTree(new Header("MESSAGES"));
        int i2 = 0;
        while (i2 < this.messages.length) {
            msgsTree.addChild(this.messages[i2].toStructureTree());
            ++i2;
        }
        tree.addChild(msgsTree);
        return tree;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTestResponsible() {
        return this.testResponsible;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public ParameterInterface[] getInternalParameters() {
        return this.internalParameters;
    }

    private StructureTree getInternalParameterTree() {
        StructureTree out = new StructureTree(new Header(TEST_INTERNAL_PARAMETERS));
        int i = 0;
        while (i < this.internalParameters.length) {
            if (this.internalParameters[i].getType().equals("STRING")) {
                StructureTree child = new StructureTree(new Header(this.internalParameters[i].getName()));
                child.setText((String)((Object)this.internalParameters[i].getValue()));
                out.addChild(child);
            } else {
                StructureTree value;
                if (this.internalParameters[i].getType().equals("STRING[]")) {
                    value = (StructureTree)this.internalParameters[i].getValue();
                    Header paramHeader = new Header(TEST_INTERNAL_PARAMETERS);
                    paramHeader.setParameter("NAME", this.name);
                    paramHeader.setParameter("TYPE", this.internalParameters[i].getType());
                    StructureTree paramTree = new StructureTree(paramHeader);
                    if (null != value && 0 != ((StructureTree)value).length) {
                        Header contentHeader = new Header("VALUE");
                        StructureTree contentTree = new StructureTree(contentHeader);
                        paramTree.addNewChild(contentTree);
                        int ii = 0;
                        while (ii < ((StructureTree)value).length) {
                            if (null != value[ii]) {
                                StructureTree itemTree = new StructureTree(new Header("ITEM"));
                                itemTree.setText((String)value[i]);
                                contentTree.addChild(itemTree);
                            }
                            ++ii;
                        }
                    }
                    return paramTree;
                }
                if (this.internalParameters[i].getType().equals("DEEP STRUCTURE")) {
                    value = (StructureTree)this.internalParameters[i].getValue();
                    Header paramHeader = new Header(TEST_INTERNAL_PARAMETERS);
                    paramHeader.setParameter("NAME", this.name);
                    paramHeader.setParameter("TYPE", "DEEP STRUCTURE");
                    StructureTree paramTree = new StructureTree(paramHeader);
                    if (null != value) {
                        Header contentHeader = new Header("VALUE");
                        StructureTree contentTree = new StructureTree(contentHeader);
                        paramTree.addNewChild(contentTree);
                        contentTree.addNewChild(value);
                    }
                    return paramTree;
                }
            }
            ++i;
        }
        return out;
    }

    public ParameterInterface getInternalParameter(String parameterName) {
        int i = 0;
        while (i < this.internalParameters.length) {
            if (this.internalParameters[i].getName().equals(parameterName)) {
                return this.internalParameters[i];
            }
            ++i;
        }
        return null;
    }

    public ParameterInterface getInputParameter(String parameterName) {
        int i = 0;
        while (i < this.inputParameters.length) {
            if (this.inputParameters[i].getName().equals(parameterName)) {
                return this.inputParameters[i];
            }
            ++i;
        }
        return null;
    }

    public ParameterInterface[] getInputParameters() {
        return this.inputParameters;
    }

    public int getNodeType() {
        return 1;
    }

    public ITestMessageDescription[] getMessages() {
        return this.messages;
    }
}

