/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jlint.TestComponentInterface;
import com.sap.tc.jtools.jlint.exceptions.IllegalParameterException;
import com.sap.tc.jtools.jlint.exceptions.InvalidDataProviderException;
import com.sap.tc.jtools.jlint.exceptions.NonexistentDataClassException;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;

public class ProcessorUnitFactory {
    private static TestProviderInterface testProvider;

    public static TestComponentInterface createTestComponent(TestDescriptionInterface testDescription) throws InvalidDataProviderException {
        String className = (String)((Object)testDescription.getInternalParameter("TEST_CLASS").getValue());
        Class diClass = null;
        try {
            diClass = testProvider != null ? testProvider.loadTestClass(className) : Class.forName(className);
        }
        catch (Exception e) {
            throw new NonexistentDataClassException("Testclass is unknown: " + className, e);
        }
        TestComponentInterface di = null;
        try {
            di = (TestComponentInterface)diClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalParameterException("Cannot instantiate class: " + className, e);
        }
        di.setInternalParameters(testDescription.getInternalParameters());
        return di;
    }

    public static void setTestProvider(TestProviderInterface manager) {
        testProvider = manager;
    }
}

