/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.NestableRuntimeException;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class CollectResults {
    private Dispatcher dispatcher = null;
    private List rawResults = new ArrayList();
    private Properties properties = new Properties();
    private PerformResponse collectedResponse;
    private FilenameFilter indexFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return "index.xml".equals(name);
        }
    };
    private FileFilter resultFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().startsWith("JLResults") && file.getName().endsWith(".xml");
        }
    };

    public CollectResults(String jlinHomeDir) throws BadTreeException, FileNotFoundException, IOException, XMLParseException {
        TestProvider provider = null;
        provider = TestProvider.isInitialized() ? TestProvider.getTestProvider() : TestProvider.initialize(new File(jlinHomeDir, "/config/config.xml"));
        this.dispatcher = new Dispatcher(provider);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public int execute(String resDir, boolean cleanUp) {
        try {
            return this.execute(resDir, new File(resDir, "index.xml"), cleanUp);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(String resDir, File resultFile, boolean cleanUp) throws IOException {
        int severityLevel = 0;
        this.rawResults.clear();
        File currDir = new File(resDir);
        if (!currDir.isDirectory()) {
            throw new IllegalArgumentException(resDir + " is not a directory!");
        }
        this.collectedResponse = new PerformResponse(currDir.getAbsolutePath());
        this.collectedResponse.setProperties(this.properties);
        this.addResultsFromDirectory(currDir);
        ResultInterface[] processedResults = this.dispatcher.processResults(this.rawResults.toArray(new ResultInterface[0]));
        int i = 0;
        while (i < processedResults.length) {
            severityLevel = CollectResults.combine(severityLevel, processedResults[i].getPriority());
            this.collectedResponse.addResult(processedResults[i]);
            ++i;
        }
        BufferedWriter fileWriter = null;
        try {
            fileWriter = new BufferedWriter(new FileWriter(resultFile));
            XMLTool.writeDocument((StructureTree)this.collectedResponse.toStructureTree(), (Writer)fileWriter);
            Object var10_9 = null;
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
            throw throwable;
        }
        if (cleanUp) {
            this.cleanUpDirectory(currDir);
        }
        ((Hashtable)this.properties).clear();
        return severityLevel;
    }

    public PerformResponse getCollectedResponse() {
        return this.collectedResponse;
    }

    private void addResultsFromDirectory(File dir) {
        File[] indexArray = dir.listFiles(this.indexFilter);
        if (indexArray.length == 1) {
            this.addResultsFromFile(indexArray[0]);
            return;
        }
        File[] children = dir.listFiles(this.resultFilter);
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                this.addResultsFromDirectory(children[i]);
            } else {
                this.addResultsFromFile(children[i]);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addResultsFromFile(File file) {
        String fileName = null;
        Reader fileReader = null;
        try {
            try {
                fileName = file.getCanonicalPath();
                fileReader = new BufferedReader(new FileReader(file));
                PerformResponse pr = new PerformResponse(XMLTool.parseReader((Reader)fileReader));
                this.rawResults.addAll(Arrays.asList(pr.getResults()));
            }
            catch (BadTreeException e) {
                throw new NestableRuntimeException("JLin error: badly formed file: " + fileName, e);
            }
            catch (IOException e) {
                throw new NestableRuntimeException("JLin error: IO Exception: " + fileName, e);
            }
            catch (XMLParseException e) {
                throw new NestableRuntimeException("JLin error: XML Exception: " + fileName, e);
            }
            Object var8_6 = null;
            if (fileReader == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (fileReader == null) throw throwable;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException e1) {
                throw new NestableRuntimeException("JLin error: IOException: " + fileName, e1);
            }
        }
        try {}
        catch (IOException e1) {
            throw new NestableRuntimeException("JLin error: IOException: " + fileName, e1);
        }
        fileReader.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PerformResponse getResponseFromFile(File file) throws IOException {
        BufferedReader fileReader = null;
        PerformResponse pr = null;
        try {
            try {
                fileReader = new BufferedReader(new FileReader(file));
                pr = new PerformResponse(XMLTool.parseReader((Reader)fileReader));
            }
            catch (BadTreeException e) {
                throw new NestableRuntimeException("JLin error: badly formed file: " + file.getAbsolutePath(), e);
            }
            catch (XMLParseException e) {
                throw new NestableRuntimeException("JLin error: XML Exception: " + file.getAbsolutePath(), e);
            }
            Object var7_4 = null;
            if (fileReader == null) return pr;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (fileReader == null) throw throwable;
            ((Reader)fileReader).close();
            throw throwable;
        }
        ((Reader)fileReader).close();
        return pr;
    }

    private void cleanUpDirectory(File dir) {
        File[] indexArray = dir.listFiles(this.indexFilter);
        if (indexArray.length == 1) {
            indexArray[0].delete();
            return;
        }
        File[] children = dir.listFiles(this.resultFilter);
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                this.cleanUpDirectory(children[i]);
            } else {
                children[i].delete();
            }
            ++i;
        }
    }

    private static int combine(int levelSoFar, int newEntry) {
        if (levelSoFar == 1) {
            return 1;
        }
        if (newEntry == 1) {
            return 1;
        }
        if (levelSoFar == 2) {
            return 2;
        }
        if (newEntry == 2) {
            return 2;
        }
        if (levelSoFar == 3) {
            return 3;
        }
        if (newEntry == 3) {
            return 3;
        }
        return levelSoFar;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collect(File[] rawResultFiles, File collectedResultFile) throws IOException {
        ArrayList<ResultInterface> allResultList = new ArrayList<ResultInterface>();
        int i = 0;
        while (i < rawResultFiles.length) {
            allResultList.addAll(Arrays.asList(this.getResponseFromFile(rawResultFiles[i]).getResults()));
            ++i;
        }
        this.collectedResponse = new PerformResponse("Collected Response");
        this.collectedResponse.setProperties(this.properties);
        ResultInterface[] processedResults = this.dispatcher.processResults(allResultList.toArray(new ResultInterface[0]));
        this.collectedResponse.addResults(processedResults);
        BufferedWriter fileWriter = null;
        try {
            fileWriter = new BufferedWriter(new FileWriter(collectedResultFile));
            XMLTool.writeDocument((StructureTree)this.collectedResponse.toStructureTree(), (Writer)fileWriter);
            Object var8_7 = null;
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
            throw throwable;
        }
        ((Hashtable)this.properties).clear();
    }
}

