/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.merge.ProjectElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UpdateWizardPage
extends CVSWizardPage {
    IProject project;
    TreeViewer tree;
    CVSTag result;
    ICVSRemoteFolder remote;
    boolean doOverwrite;

    public UpdateWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        Label description = new Label(composite, 64);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 350;
        description.setLayoutData((Object)data);
        description.setText(Policy.bind("UpdateWizardPage.description"));
        this.tree = this.createTree(composite);
        this.tree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tree.setSorter(new ViewerSorter(){

            public int compare(Viewer v, Object o1, Object o2) {
                int result = super.compare(v, o1, o2);
                if (o1 instanceof TagElement && o2 instanceof TagElement) {
                    return -result;
                }
                return result;
            }
        });
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)UpdateWizardPage.this.tree.getSelection()).getFirstElement();
                if (selected instanceof TagElement) {
                    UpdateWizardPage.this.result = ((TagElement)selected).getTag();
                    UpdateWizardPage.this.setPageComplete(true);
                } else {
                    UpdateWizardPage.this.result = null;
                    UpdateWizardPage.this.setPageComplete(false);
                }
            }
        });
        CVSWizardPage.createLabel(composite, "");
        CVSWizardPage.createLabel(composite, "");
        this.doOverwrite = false;
        final Button overwrite = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        overwrite.setLayoutData((Object)data);
        overwrite.setText(Policy.bind("UpdateWizardPage.overwrite"));
        overwrite.setSelection(this.doOverwrite);
        overwrite.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UpdateWizardPage.this.doOverwrite = overwrite.getSelection();
            }
        });
        this.setControl((Control)composite);
        this.tree.setInput((Object)new ProjectElement(CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project), 15));
        Runnable refresh = new Runnable(){

            public void run() {
                UpdateWizardPage.this.tree.refresh();
            }
        };
        TagConfigurationDialog.createTagDefinitionButtons(this.getShell(), composite, new ICVSFolder[]{CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project)}, this.convertVerticalDLUsToPixels(14), this.convertHorizontalDLUsToPixels(61), refresh, refresh);
        Label seperator = new Label(composite, 258);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        this.setPageComplete(false);
    }

    protected TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 2820);
        tree.setLayoutData((Object)new GridData(1808));
        return new TreeViewer(tree);
    }

    public void setProject(IProject project) {
        this.project = project;
        try {
            this.remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        }
        catch (TeamException teamException) {}
    }

    public CVSTag getTag() {
        return this.result;
    }

    public Command.LocalOption[] getLocalOptions() {
        if (this.doOverwrite) {
            return new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES};
        }
        return Command.NO_LOCAL_OPTIONS;
    }
}

