/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RepositorySelectionPage
extends CVSWizardPage {
    private TableViewer table;
    private Button useExistingRepo;
    private Button useNewRepo;
    private ICVSRepositoryLocation result;

    public RepositorySelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected TableViewer createTable(Composite parent, int span) {
        Table table = new Table(parent, 68356);
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        return new TableViewer(table);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.sharing_select_repository_page_context");
        this.createWrappingLabel(composite, Policy.bind("RepositorySelectionPage.description"), 0, 1);
        this.useNewRepo = this.createRadioButton(composite, Policy.bind("RepositorySelectionPage.useNew"), 1);
        this.useExistingRepo = this.createRadioButton(composite, Policy.bind("RepositorySelectionPage.useExisting"), 1);
        this.table = this.createTable(composite, 1);
        this.table.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositorySelectionPage.this.result = (ICVSRepositoryLocation)((IStructuredSelection)RepositorySelectionPage.this.table.getSelection()).getFirstElement();
                RepositorySelectionPage.this.setPageComplete(true);
            }
        });
        this.useExistingRepo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (RepositorySelectionPage.this.useNewRepo.getSelection()) {
                    RepositorySelectionPage.this.table.getTable().setEnabled(false);
                    RepositorySelectionPage.this.result = null;
                } else {
                    RepositorySelectionPage.this.table.getTable().setEnabled(true);
                    RepositorySelectionPage.this.result = (ICVSRepositoryLocation)((IStructuredSelection)RepositorySelectionPage.this.table.getSelection()).getFirstElement();
                }
                RepositorySelectionPage.this.setPageComplete(true);
            }
        });
        this.setControl((Control)composite);
        this.initializeValues();
    }

    private void initializeValues() {
        ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
        AdaptableList input = new AdaptableList((IAdaptable[])locations);
        this.table.setInput((Object)input);
        if (locations.length == 0) {
            this.useNewRepo.setSelection(true);
        } else {
            this.useExistingRepo.setSelection(true);
            this.table.setSelection((ISelection)new StructuredSelection((Object)locations[0]));
        }
    }

    public ICVSRepositoryLocation getLocation() {
        return this.result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.useExistingRepo.setFocus();
        }
    }
}

