/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.KSubstWizardCommitCommentPage;
import org.eclipse.team.internal.ccvs.ui.wizards.KSubstWizardDirtyFilesPage;
import org.eclipse.team.internal.ccvs.ui.wizards.KSubstWizardSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.KSubstWizardSharedFilesPage;
import org.eclipse.team.internal.ccvs.ui.wizards.KSubstWizardSummaryPage;

public class KSubstWizard
extends Wizard {
    private Command.KSubstOption defaultKSubst;
    private final IResource[] resources;
    private final int depth;
    private List changeList = null;
    private Command.KSubstOption changeOption = null;
    private KSubstWizardSelectionPage mainPage;
    private KSubstWizardSummaryPage summaryPage;
    private KSubstWizardSharedFilesPage sharedFilesPage;
    private KSubstWizardDirtyFilesPage dirtyFilesPage;
    private Dialog parentDialog;
    private KSubstWizardCommitCommentPage commitCommentPage;

    public KSubstWizard(IResource[] resources, int depth, Command.KSubstOption defaultOption) {
        this.defaultKSubst = defaultOption;
        this.resources = resources;
        this.depth = depth;
        this.setWindowTitle(Policy.bind("KSubstWizard.title"));
    }

    public Command.KSubstOption getKSubstOption() {
        return this.defaultKSubst;
    }

    public void addPages() {
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/keywordsub_wizban.gif");
        String pageTitle = Policy.bind("KSubstWizardSelectionPage.pageTitle");
        String pageDescription = Policy.bind("KSubstWizardSelectionPage.pageDescription");
        this.mainPage = new KSubstWizardSelectionPage(pageTitle, pageTitle, substImage, this.defaultKSubst);
        this.mainPage.setDescription(pageDescription);
        this.mainPage.setTitle(pageTitle);
        this.addPage((IWizardPage)this.mainPage);
        pageTitle = Policy.bind("KSubstWizardSummaryPage.pageTitle");
        pageDescription = Policy.bind("KSubstWizardSummaryPage.pageDescription");
        this.summaryPage = new KSubstWizardSummaryPage(pageTitle, pageTitle, substImage, false);
        this.summaryPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.summaryPage);
        pageTitle = Policy.bind("KSubstWizardSharedFilesPage.pageTitle");
        pageDescription = Policy.bind("KSubstWizardSharedFilesPage.pageDescription");
        this.sharedFilesPage = new KSubstWizardSharedFilesPage(pageTitle, pageTitle, substImage, false);
        this.sharedFilesPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.sharedFilesPage);
        pageTitle = Policy.bind("KSubstWizardDirtyFilesPage.pageTitle");
        pageDescription = Policy.bind("KSubstWizardDirtyFilesPage.pageDescription");
        this.dirtyFilesPage = new KSubstWizardDirtyFilesPage(pageTitle, pageTitle, substImage, false);
        this.dirtyFilesPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.dirtyFilesPage);
        pageTitle = Policy.bind("KSubstWizardCommitCommentPage.pageTitle");
        pageDescription = Policy.bind("KSubstWizardCommitCommentPage.pageDescription");
        this.commitCommentPage = new KSubstWizardCommitCommentPage(this.parentDialog, pageTitle, pageTitle, substImage, pageDescription);
        this.addPage((IWizardPage)this.commitCommentPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage) {
            if (this.prepareSharedFilesPage()) {
                return this.sharedFilesPage;
            }
        } else if (page == this.sharedFilesPage) {
            if (this.sharedFilesPage.includeSharedFiles() && this.prepareDirtyFilesPage()) {
                return this.dirtyFilesPage;
            }
        } else if (page == this.summaryPage) {
            return null;
        }
        this.prepareSummaryPage();
        if (page != this.commitCommentPage) {
            return this.commitCommentPage;
        }
        return this.summaryPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.summaryPage) {
            return this.commitCommentPage;
        }
        if (page == this.commitCommentPage) {
            if (this.sharedFilesPage.includeSharedFiles() && this.prepareDirtyFilesPage()) {
                return this.dirtyFilesPage;
            }
            if (this.prepareSharedFilesPage()) {
                return this.sharedFilesPage;
            }
            return this.mainPage;
        }
        if (page == this.dirtyFilesPage) {
            if (this.prepareSharedFilesPage()) {
                return this.sharedFilesPage;
            }
            return this.mainPage;
        }
        if (page == this.sharedFilesPage) {
            return this.mainPage;
        }
        return null;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean performFinish() {
        try {
            this.defaultKSubst = this.mainPage.getKSubstOption();
            final ArrayList messages = new ArrayList();
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("", 10000);
                            monitor.setTaskName(Policy.bind("KSubstWizard.working"));
                            KSubstWizard.this.computeChangeList(KSubstWizard.this.mainPage.getKSubstOption());
                            Map table = KSubstWizard.this.getProviderMapping();
                            int workPerProvider = 10000 / (table.size() + 1);
                            monitor.worked(workPerProvider);
                            Iterator it = table.entrySet().iterator();
                            while (it.hasNext()) {
                                String comment;
                                Map providerFiles;
                                Map.Entry entry = it.next();
                                CVSTeamProvider provider = (CVSTeamProvider)entry.getKey();
                                IStatus status = provider.setKeywordSubstitution(providerFiles = (Map)entry.getValue(), comment = KSubstWizard.this.commitCommentPage.getComment(), Policy.subMonitorFor(monitor, workPerProvider));
                                if (status.getCode() == 0) continue;
                                messages.add(status);
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var10_13 = null;
                    monitor.done();
                }
            });
            if (!messages.isEmpty()) {
                MultiStatus statusToDisplay;
                boolean error = false;
                MultiStatus combinedStatus = new MultiStatus("org.eclipse.team.cvs.ui", 0, Policy.bind("KSubstWizard.problemsMessage"), null);
                int i = 0;
                while (i < messages.size()) {
                    IStatus status = (IStatus)messages.get(i);
                    if (status.getSeverity() == 4 || status.getCode() == -10) {
                        error = true;
                    }
                    combinedStatus.merge(status);
                    ++i;
                }
                String message = null;
                if (combinedStatus.getChildren().length == 1) {
                    message = combinedStatus.getMessage();
                    statusToDisplay = combinedStatus.getChildren()[0];
                } else {
                    statusToDisplay = combinedStatus;
                }
                String title = error ? Policy.bind("KSubstWizard.errorTitle") : Policy.bind("KSubstWizard.warningTitle");
                CVSUIPlugin.openError(this.getShell(), title, message, new CVSException((IStatus)statusToDisplay));
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (InvocationTargetException e2) {
            CVSUIPlugin.openError(this.getShell(), Policy.bind("KSubstWizard.problemsMessage"), null, e2);
            return false;
        }
    }

    private boolean prepareDirtyFilesPage() {
        BusyIndicator.showWhile((Display)this.getContainer().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                KSubstWizard.this.computeChangeList(KSubstWizard.this.mainPage.getKSubstOption());
                KSubstWizard.this.dirtyFilesPage.setChangeList(KSubstWizard.this.changeList);
            }
        });
        return !this.dirtyFilesPage.isListEmpty();
    }

    private boolean prepareSharedFilesPage() {
        BusyIndicator.showWhile((Display)this.getContainer().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                KSubstWizard.this.computeChangeList(KSubstWizard.this.mainPage.getKSubstOption());
                KSubstWizard.this.sharedFilesPage.setChangeList(KSubstWizard.this.changeList);
            }
        });
        return !this.sharedFilesPage.isListEmpty();
    }

    private void prepareSummaryPage() {
        BusyIndicator.showWhile((Display)this.getContainer().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                KSubstWizard.this.computeChangeList(KSubstWizard.this.mainPage.getKSubstOption());
                KSubstWizard.this.summaryPage.setChangeList(KSubstWizard.this.changeList, KSubstWizard.this.getFilters());
            }
        });
    }

    private void computeChangeList(final Command.KSubstOption ksubst) {
        if (this.changeList != null) {
            if (this.changeOption == ksubst) {
                return;
            }
            this.changeList.clear();
        } else {
            this.changeList = new ArrayList();
        }
        this.changeOption = ksubst;
        final HashSet seen = new HashSet();
        int i = 0;
        while (i < this.resources.length) {
            IResource currentResource = this.resources[i];
            try {
                currentResource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        try {
                            if (resource.getType() == 1 && resource.exists() && !seen.contains(resource)) {
                                seen.add(resource);
                                IFile file = (IFile)resource;
                                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                                if (cvsFile.isManaged()) {
                                    int classification;
                                    ResourceSyncInfo info = cvsFile.getSyncInfo();
                                    if (info.isAdded()) {
                                        classification = 1;
                                    } else {
                                        if (info.isDeleted()) {
                                            return true;
                                        }
                                        classification = cvsFile.isModified(null) ? 2 : 4;
                                    }
                                    Command.KSubstOption fromKSubst = info.getKeywordMode();
                                    Command.KSubstOption toKSubst = ksubst;
                                    if (ksubst == null) {
                                        toKSubst = Command.KSubstOption.fromFile((IFile)file);
                                    }
                                    KSubstWizard.this.changeList.add(new KSubstChangeElement(file, classification, false, fromKSubst, toKSubst));
                                }
                            }
                        }
                        catch (TeamException e) {
                            throw new CoreException(e.getStatus());
                        }
                        return true;
                    }
                }, this.depth, false);
            }
            catch (CoreException e) {
                CVSUIPlugin.openError(this.getShell(), Policy.bind("KSubstWizard.problemsMessage"), null, e);
            }
            ++i;
        }
    }

    private int getFilters() {
        return 1 | (this.sharedFilesPage.includeSharedFiles() ? 4 | (this.dirtyFilesPage.includeDirtyFiles() ? 2 : 0) : 0);
    }

    private Map getProviderMapping() {
        HashMap<RepositoryProvider, HashMap<IFile, Command.KSubstOption>> table = new HashMap<RepositoryProvider, HashMap<IFile, Command.KSubstOption>>();
        int filter = this.getFilters();
        Iterator it = this.changeList.iterator();
        while (it.hasNext()) {
            KSubstChangeElement change = (KSubstChangeElement)it.next();
            if (change.isExcluded() || !change.isNewKSubstMode() || !change.matchesFilter(filter)) continue;
            IFile file = change.getFile();
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)file.getProject(), (String)CVSProviderPlugin.getTypeId());
            HashMap<IFile, Command.KSubstOption> providerMap = (HashMap<IFile, Command.KSubstOption>)table.get(provider);
            if (providerMap == null) {
                providerMap = new HashMap<IFile, Command.KSubstOption>();
                table.put(provider, providerMap);
            }
            providerMap.put(file, change.toKSubst);
        }
        return table;
    }

    public void setParentDialog(Dialog dialog) {
        this.parentDialog = dialog;
    }

    public class KSubstChangeElement {
        public static final int ADDED_FILE = 1;
        public static final int CHANGED_FILE = 2;
        public static final int UNCHANGED_FILE = 4;
        private IFile file;
        private int classification;
        private boolean excluded;
        private Command.KSubstOption fromKSubst;
        private Command.KSubstOption toKSubst;

        private KSubstChangeElement(IFile file, int classification, boolean excluded, Command.KSubstOption fromKSubst, Command.KSubstOption toKSubst) {
            this.file = file;
            this.classification = classification;
            this.excluded = excluded;
            this.fromKSubst = fromKSubst;
            this.toKSubst = toKSubst;
        }

        public boolean matchesFilter(int filter) {
            return (this.classification & filter) != 0;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public boolean isNewKSubstMode() {
            return !this.fromKSubst.equals((Object)this.toKSubst);
        }

        public void setKSubst(Command.KSubstOption toKSubst) {
            this.toKSubst = toKSubst;
        }

        public Command.KSubstOption getKSubst() {
            return this.toKSubst;
        }

        public IFile getFile() {
            return this.file;
        }
    }
}

