/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConfigurationWizardMainPage
extends CVSWizardPage {
    private boolean showValidate;
    private boolean validate;
    private Combo connectionMethodCombo;
    private Combo userCombo;
    private Text passwordText;
    private Text portText;
    private Button useDefaultPort;
    private Button useCustomPort;
    private Combo hostCombo;
    private Combo repositoryPathCombo;
    private Button validateButton;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private Properties properties = null;
    private static final String STORE_USERNAME_ID = "ConfigurationWizardMainPage.STORE_USERNAME_ID";
    private static final String STORE_HOSTNAME_ID = "ConfigurationWizardMainPage.STORE_HOSTNAME_ID";
    private static final String STORE_PATH_ID = "ConfigurationWizardMainPage.STORE_PATH_ID";
    private static final String STORE_DONT_VALIDATE_ID = "ConfigurationWizardMainPage.STORE_DONT_VALIDATE_ID";
    private IDialogSettings settings;

    public ConfigurationWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected IDialogSettings getDialogSettings() {
        return this.settings;
    }

    protected void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    private void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.sharing_new_repository_page_context");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ConfigurationWizardMainPage.this.updateWidgetEnablements();
            }
        };
        Group g = this.createGroup(composite, Policy.bind("ConfigurationWizardMainPage.Location_1"));
        CVSWizardPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.host"));
        this.hostCombo = this.createEditableCombo((Composite)g);
        this.hostCombo.addListener(13, listener);
        this.hostCombo.addListener(24, listener);
        CVSWizardPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.repositoryPath"));
        this.repositoryPathCombo = this.createEditableCombo((Composite)g);
        this.repositoryPathCombo.addListener(13, listener);
        this.repositoryPathCombo.addListener(24, listener);
        g = this.createGroup(composite, Policy.bind("ConfigurationWizardMainPage.Authentication_2"));
        CVSWizardPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.userName"));
        this.userCombo = this.createEditableCombo((Composite)g);
        this.userCombo.addListener(13, listener);
        this.userCombo.addListener(24, listener);
        CVSWizardPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.password"));
        this.passwordText = CVSWizardPage.createTextField((Composite)g);
        this.passwordText.setEchoChar('*');
        g = this.createGroup(composite, Policy.bind("ConfigurationWizardMainPage.Connection_3"));
        CVSWizardPage.createLabel((Composite)g, Policy.bind("ConfigurationWizardMainPage.connection"));
        this.connectionMethodCombo = this.createCombo((Composite)g);
        Composite portGroup = new Composite((Composite)g, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        portGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        portGroup.setLayout((Layout)layout);
        this.useDefaultPort = this.createRadioButton(portGroup, Policy.bind("ConfigurationWizardMainPage.useDefaultPort"), 2);
        this.useCustomPort = this.createRadioButton(portGroup, Policy.bind("ConfigurationWizardMainPage.usePort"), 1);
        this.useCustomPort.addListener(13, listener);
        this.portText = CVSWizardPage.createTextField(portGroup);
        this.portText.addListener(24, listener);
        if (this.showValidate) {
            Composite validateButtonTabGroup = new Composite(composite, 0);
            data = new GridData();
            data.horizontalSpan = 2;
            validateButtonTabGroup.setLayoutData((Object)data);
            validateButtonTabGroup.setLayout((Layout)new FillLayout());
            this.validateButton = new Button(validateButtonTabGroup, 32);
            this.validateButton.setText(Policy.bind("ConfigurationWizardAutoconnectPage.validate"));
            this.validateButton.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ConfigurationWizardMainPage.this.validate = ConfigurationWizardMainPage.this.validateButton.getSelection();
                }
            });
        }
        this.initializeValues();
        this.updateWidgetEnablements();
        this.hostCombo.setFocus();
        this.setControl((Control)composite);
    }

    protected Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 0);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        return group;
    }

    public boolean finish(IProgressMonitor monitor) {
        Properties result = new Properties();
        result.setProperty("connection", this.connectionMethodCombo.getText());
        result.setProperty("user", this.userCombo.getText());
        result.setProperty("password", this.passwordText.getText());
        result.setProperty("host", this.hostCombo.getText());
        if (this.useCustomPort.getSelection()) {
            result.setProperty("port", this.portText.getText());
        }
        result.setProperty("root", this.repositoryPathCombo.getText());
        this.properties = result;
        this.saveWidgetValues();
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void initializeValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] userNames;
            String[] paths;
            String[] hostNames = settings.getArray(STORE_HOSTNAME_ID);
            if (hostNames != null) {
                int i = 0;
                while (i < hostNames.length) {
                    this.hostCombo.add(hostNames[i]);
                    ++i;
                }
            }
            if ((paths = settings.getArray(STORE_PATH_ID)) != null) {
                int i = 0;
                while (i < paths.length) {
                    this.repositoryPathCombo.add(paths[i]);
                    ++i;
                }
            }
            if ((userNames = settings.getArray(STORE_USERNAME_ID)) != null) {
                int i = 0;
                while (i < userNames.length) {
                    this.userCombo.add(userNames[i]);
                    ++i;
                }
            }
            if (this.showValidate) {
                this.validate = !settings.getBoolean(STORE_DONT_VALIDATE_ID);
                this.validateButton.setSelection(this.validate);
            }
        }
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            this.connectionMethodCombo.add(methods[i].getName());
            ++i;
        }
        this.connectionMethodCombo.select(0);
        this.useDefaultPort.setSelection(true);
        if (this.properties != null) {
            String repositoryPath;
            String port;
            String host;
            String password;
            String method = this.properties.getProperty("connection");
            if (method == null) {
                this.connectionMethodCombo.select(0);
            } else {
                this.connectionMethodCombo.select(this.connectionMethodCombo.indexOf(method));
            }
            String user = this.properties.getProperty("user");
            if (user != null) {
                this.userCombo.setText(user);
            }
            if ((password = this.properties.getProperty("password")) != null) {
                this.passwordText.setText(password);
            }
            if ((host = this.properties.getProperty("host")) != null) {
                this.hostCombo.setText(host);
            }
            if ((port = this.properties.getProperty("port")) != null) {
                this.useCustomPort.setSelection(true);
                this.portText.setText(port);
            }
            if ((repositoryPath = this.properties.getProperty("root")) != null) {
                this.repositoryPathCombo.setText(repositoryPath);
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] userNames = settings.getArray(STORE_USERNAME_ID);
            if (userNames == null) {
                userNames = new String[]{};
            }
            userNames = this.addToHistory(userNames, this.userCombo.getText());
            settings.put(STORE_USERNAME_ID, userNames);
            String[] hostNames = settings.getArray(STORE_HOSTNAME_ID);
            if (hostNames == null) {
                hostNames = new String[]{};
            }
            hostNames = this.addToHistory(hostNames, this.hostCombo.getText());
            settings.put(STORE_HOSTNAME_ID, hostNames);
            String[] paths = settings.getArray(STORE_PATH_ID);
            if (paths == null) {
                paths = new String[]{};
            }
            paths = this.addToHistory(paths, this.repositoryPathCombo.getText());
            settings.put(STORE_PATH_ID, paths);
            if (this.showValidate) {
                settings.put(STORE_DONT_VALIDATE_ID, !this.validate);
            }
        }
    }

    public void setShowValidate(boolean showValidate) {
        this.showValidate = showValidate;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void updateWidgetEnablements() {
        if (this.useDefaultPort.getSelection()) {
            this.portText.setEnabled(false);
        } else {
            this.portText.setEnabled(true);
        }
        this.validateFields();
    }

    private void validateFields() {
        String user = this.userCombo.getText();
        if (user.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (user.indexOf(64) != -1 || user.indexOf(58) != -1) {
            this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidUserName"));
            this.setPageComplete(false);
            return;
        }
        String host = this.hostCombo.getText();
        if (host.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (host.indexOf(58) != -1) {
            this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidHostName"));
            this.setPageComplete(false);
            return;
        }
        if (this.portText.isEnabled()) {
            if (this.portText.getText().length() == 0) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
            try {
                Integer.parseInt(this.portText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidPort"));
                this.setPageComplete(false);
                return;
            }
        }
        if (this.repositoryPathCombo.getText().length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        String pathString = this.repositoryPathCombo.getText();
        Path path = new Path(pathString);
        String[] segments = path.segments();
        int i = 0;
        while (i < segments.length) {
            String string = segments[i];
            if (string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ') {
                this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidPathWithSpaces"));
                this.setPageComplete(false);
                return;
            }
            ++i;
        }
        if (pathString.indexOf("//") != -1) {
            if (pathString.indexOf("//") == 2) {
                this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.useNTFormat"));
            } else {
                this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidPathWithSlashes"));
            }
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.hostCombo.setFocus();
        }
    }
}

