/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutIntoProjectSelectionPage;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.team.internal.ui.PromptingDialog;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CheckoutIntoWizard
extends Wizard {
    CheckoutIntoProjectSelectionPage projectSelectionPage;
    ICVSRemoteFolder remoteFolder;

    public CheckoutIntoWizard(ICVSRemoteFolder remoteFolder) {
        this.remoteFolder = remoteFolder;
        this.setWindowTitle(Policy.bind("CheckoutIntoWizard.title"));
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif");
        this.projectSelectionPage = new CheckoutIntoProjectSelectionPage("ProjectSelectionPage", Policy.bind("CheckoutIntoWizard.projectSelectionPageTitle"), substImage, Policy.bind("CheckoutIntoWizard.projectSelectionPageDescription"));
        this.projectSelectionPage.setRemoteFolder(this.remoteFolder);
        this.addPage((IWizardPage)this.projectSelectionPage);
    }

    public boolean performFinish() {
        try {
            final IContainer targetFolder = this.projectSelectionPage.getLocalFolder();
            if (targetFolder == null) {
                return false;
            }
            PromptingDialog prompt = new PromptingDialog(this.getShell(), new IResource[]{targetFolder}, this.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("CheckoutIntoWizard.confirmOverwrite"));
            if (prompt.promptForMultiple().length == 0) {
                return false;
            }
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(null, 100);
                    try {
                        try {
                            CheckoutIntoWizard.this.validateUniqueMapping(CheckoutIntoWizard.this.remoteFolder.getFolderSyncInfo(), targetFolder, Policy.subMonitorFor(monitor, 10));
                            CVSWorkspaceRoot.checkout((ICVSRemoteFolder)CheckoutIntoWizard.this.remoteFolder, (IContainer)targetFolder, (boolean)true, (boolean)CheckoutIntoWizard.this.projectSelectionPage.isRecurse(), (IProgressMonitor)Policy.subMonitorFor(monitor, 90));
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var3_5 = null;
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.handle(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), Policy.bind("CheckoutIntoWizard.error"), null, e);
    }

    protected IPromptCondition getOverwriteLocalAndFileSystemPrompt() {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                return resource.exists();
            }

            public String promptMessage(IResource resource) {
                return Policy.bind("CheckoutIntoWizard.thisResourceExists", resource.getFullPath().toString());
            }
        };
    }

    private void validateUniqueMapping(final FolderSyncInfo folderSyncInfo, final IContainer targetFolder, IProgressMonitor iProgressMonitor) throws CVSException {
        final IProject iProject = targetFolder.getProject();
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)iProject);
        cvsFolder.accept(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                if (!folder.isCVSFolder()) {
                    return;
                }
                IResource resource = folder.getIResource();
                if (resource == null || resource.equals((Object)targetFolder)) {
                    return;
                }
                FolderSyncInfo info = folder.getFolderSyncInfo();
                if (info.getRoot().equals(folderSyncInfo.getRoot()) && info.getRepository().equals(folderSyncInfo.getRepository())) {
                    throw new CVSException(Policy.bind("CheckoutIntoWizard.,mappingAlredyExists", new Object[]{folderSyncInfo.getRepository(), iProject.getName(), targetFolder.getProjectRelativePath().toString(), resource.getProjectRelativePath().toString()}));
                }
                folder.acceptChildren((ICVSResourceVisitor)this);
            }
        });
    }
}

