/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ccvs.ui.sync.MergeAction;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.TeamFile;

public class UpdateSyncAction
extends MergeAction {
    public UpdateSyncAction(CVSSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(model, sp, label, shell);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SyncSet run(SyncSet syncSet, IProgressMonitor monitor) {
        ITeamNode[] changed;
        boolean result = this.saveIfNecessary();
        if (!result) {
            return null;
        }
        boolean onlyUpdateAutomergeable = false;
        if (syncSet.hasConflicts() || syncSet.hasOutgoingChanges()) {
            if (syncSet.hasAutoMergeableConflicts()) {
                switch (this.promptForMergeableConflicts()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        onlyUpdateAutomergeable = true;
                        syncSet.removeNonMergeableNodes();
                        break;
                    }
                    case 2: {
                        onlyUpdateAutomergeable = false;
                    }
                }
            } else if (!this.promptForConflicts()) {
                return null;
            }
        }
        if ((changed = syncSet.getChangedNodes()).length == 0) {
            return syncSet;
        }
        ArrayList<ITeamNode> updateIgnoreLocalShallow = new ArrayList<ITeamNode>();
        ArrayList<ITeamNode> updateDeep = new ArrayList<ITeamNode>();
        ArrayList<ITeamNode> updateShallow = new ArrayList<ITeamNode>();
        HashSet<IDiffContainer> parentCreationElements = new HashSet<IDiffContainer>();
        HashSet<Object> parentConflictElements = new HashSet<Object>();
        HashSet<IDiffContainer> parentDeletionElements = new HashSet<IDiffContainer>();
        ArrayList<ITeamNode> makeIncoming = new ArrayList<ITeamNode>();
        ArrayList<ITeamNode> updateDeletions = new ArrayList<ITeamNode>();
        ArrayList<ITeamNode> deletions = new ArrayList<ITeamNode>();
        int i = 0;
        while (i < changed.length) {
            IDiffContainer parent = changed[i].getParent();
            if (parent != null) {
                int parentKind = changed[i].getParent().getKind();
                if ((parentKind & 3) == 1 && (parentKind & 0xC) == 8) {
                    parentCreationElements.add(parent);
                } else if (this.isLocallyDeletedFolder((IDiffElement)parent)) {
                    parentDeletionElements.add(parent);
                } else if ((parentKind & 0xC) == 12) {
                    parentConflictElements.add(parent);
                }
            }
            ITeamNode changedNode = changed[i];
            IResource resource = changedNode.getResource();
            int kind = changedNode.getKind();
            switch (kind & 0xC) {
                case 8: {
                    switch (kind & 3) {
                        case 1: {
                            updateIgnoreLocalShallow.add(changedNode);
                            break;
                        }
                        case 2: {
                            updateDeletions.add(changedNode);
                            break;
                        }
                        case 3: {
                            updateDeep.add(changedNode);
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (kind & 3) {
                        case 1: {
                            deletions.add(changedNode);
                            break;
                        }
                        case 2: {
                            if (resource.getType() != 1) break;
                            makeIncoming.add(changedNode);
                            updateDeep.add(changedNode);
                            break;
                        }
                        case 3: {
                            updateIgnoreLocalShallow.add(changedNode);
                            break;
                        }
                    }
                    break;
                }
                case 12: {
                    switch (kind & 3) {
                        case 1: {
                            if (changedNode instanceof IDiffContainer) {
                                parentConflictElements.add(changedNode);
                                break;
                            }
                            makeIncoming.add(changedNode);
                            deletions.add(changedNode);
                            updateIgnoreLocalShallow.add(changedNode);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (resource.getType() != 1) break;
                            if (onlyUpdateAutomergeable && (changedNode.getKind() & 0x20) != 0) {
                                updateShallow.add(changedNode);
                                break;
                            }
                            if (((TeamFile)changedNode).getMergeResource().getSyncElement().getRemote() == null) {
                                deletions.add(changedNode);
                                break;
                            }
                            updateIgnoreLocalShallow.add(changedNode);
                            if (resource.exists()) break;
                            makeIncoming.add(changedNode);
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        try {
            try {
                Iterator it;
                int work = (makeIncoming.size() + deletions.size() + updateDeletions.size() + updateShallow.size() + updateIgnoreLocalShallow.size() + updateDeep.size()) * 100;
                monitor.beginTask(null, work);
                RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                if (parentDeletionElements.size() > 0) {
                    it = parentDeletionElements.iterator();
                    while (it.hasNext()) {
                        this.recreateLocallyDeletedFolder((IDiffElement)it.next());
                    }
                }
                if (parentCreationElements.size() > 0) {
                    it = parentCreationElements.iterator();
                    while (it.hasNext()) {
                        IDiffElement element = (IDiffElement)it.next();
                        this.makeInSync(element);
                        updateIgnoreLocalShallow.remove(element);
                    }
                }
                if (parentConflictElements.size() > 0) {
                    it = parentConflictElements.iterator();
                    while (it.hasNext()) {
                        this.makeInSync((IDiffElement)it.next());
                    }
                }
                it = makeIncoming.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        if (deletions.size() > 0) {
                            this.runLocalDeletions(deletions.toArray(new ITeamNode[deletions.size()]), manager, Policy.subMonitorFor(monitor, deletions.size() * 100));
                        }
                        if (updateDeletions.size() > 0) {
                            this.runUpdateDeletions(updateDeletions.toArray(new ITeamNode[updateDeletions.size()]), manager, Policy.subMonitorFor(monitor, updateDeletions.size() * 100));
                        }
                        if (updateShallow.size() > 0) {
                            this.runUpdateShallow(updateShallow.toArray(new ITeamNode[updateShallow.size()]), manager, Policy.subMonitorFor(monitor, updateShallow.size() * 100));
                        }
                        if (updateIgnoreLocalShallow.size() > 0) {
                            this.runUpdateIgnoreLocalShallow(updateIgnoreLocalShallow.toArray(new ITeamNode[updateIgnoreLocalShallow.size()]), manager, Policy.subMonitorFor(monitor, updateIgnoreLocalShallow.size() * 100));
                        }
                        if (updateDeep.size() > 0) {
                            this.runUpdateDeep(updateDeep.toArray(new ITeamNode[updateDeep.size()]), manager, Policy.subMonitorFor(monitor, updateDeep.size() * 100));
                        }
                        break;
                    }
                    ITeamNode node = (ITeamNode)it.next();
                    CVSRemoteSyncElement element = CVSSyncCompareInput.getSyncElementFrom(node);
                    element.makeIncoming(Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (TeamException e) {
                this.handle(e);
                Object var20_24 = null;
                monitor.done();
                return null;
            }
            catch (CoreException e) {
                this.handle(e);
                Object var20_25 = null;
                monitor.done();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            monitor.done();
            throw throwable;
        }
        Object var20_27 = null;
        monitor.done();
        return syncSet;
    }

    protected void deleteAndKeepHistory(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource.getType() == 1) {
            ((IFile)resource).delete(false, true, monitor);
        } else {
            resource.delete(false, monitor);
        }
    }

    protected void runLocalDeletions(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException, CoreException {
        monitor.beginTask(null, nodes.length * 100);
        int i = 0;
        while (i < nodes.length) {
            ITeamNode node = nodes[i];
            CVSRemoteSyncElement element = CVSSyncCompareInput.getSyncElementFrom(node);
            element.makeIncoming(Policy.subMonitorFor(monitor, 50));
            this.deleteAndKeepHistory(element.getLocal(), Policy.subMonitorFor(monitor, 50));
            ++i;
        }
        monitor.done();
    }

    protected void runUpdateDeletions(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        manager.update(this.getIResourcesFrom(nodes), new Command.LocalOption[]{Command.DO_NOT_RECURSE}, false, monitor);
    }

    protected void runUpdateDeep(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        manager.update(this.getIResourcesFrom(nodes), Command.NO_LOCAL_OPTIONS, false, monitor);
    }

    protected void runUpdateIgnoreLocalShallow(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        manager.update(this.getIResourcesFrom(nodes), new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES, Command.DO_NOT_RECURSE}, false, monitor);
    }

    protected void runUpdateShallow(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        manager.update(this.getIResourcesFrom(nodes), new Command.LocalOption[]{Command.DO_NOT_RECURSE}, false, monitor);
    }

    protected IResource[] getIResourcesFrom(ITeamNode[] nodes) {
        ArrayList<IResource> resources = new ArrayList<IResource>(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            resources.add(nodes[i].getResource());
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected boolean isEnabled(ITeamNode node) {
        return new SyncSet((IStructuredSelection)new StructuredSelection((Object)node)).hasIncomingChanges();
    }

    protected int promptForMergeableConflicts() {
        final boolean[] doAutomerge = new boolean[1];
        final int[] result = new int[]{1};
        final Shell shell = this.getShell();
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ConfirmDialog dialog = new ConfirmDialog(shell);
                result[0] = dialog.open();
                doAutomerge[0] = dialog.getAutomerge();
            }
        });
        if (result[0] == 1) {
            return 0;
        }
        return doAutomerge[0] ? 1 : 2;
    }

    protected boolean promptForConflicts() {
        final boolean[] result = new boolean[1];
        final Shell shell = this.getShell();
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)Policy.bind("UpdateSyncAction.Overwrite_local_changes__5"), (String)Policy.bind("UpdateSyncAction.You_have_local_changes_you_are_about_to_overwrite._Do_you_wish_to_continue__6"));
            }
        });
        return result[0];
    }

    protected void removeNonApplicableNodes(SyncSet set, int syncMode) {
        set.removeConflictingNodes();
        set.removeOutgoingNodes();
    }

    protected String getHelpContextID() {
        return "org.eclipse.team.cvs.ui.sync_update_action_context";
    }

    protected String getErrorTitle() {
        return Policy.bind("UpdateAction.update");
    }

    public static class ConfirmDialog
    extends MessageDialog {
        private boolean autoMerge = true;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            private final /* synthetic */ ConfirmDialog this$1;
            {
                this.this$1 = confirmDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    ConfirmDialog.access$1(this.this$1, button == ConfirmDialog.access$0(this.this$1));
                }
            }
        };

        public ConfirmDialog(Shell parentShell) {
            super(parentShell, Policy.bind("UpdateSyncAction.Conflicting_changes_found_1"), null, Policy.bind("UpdateSyncAction.You_have_local_changes_you_are_about_to_overwrite_2"), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            this.radio1.setText(Policy.bind("UpdateSyncAction.Only_update_resources_that_can_be_automatically_merged_3"));
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            this.radio2.setText(Policy.bind("UpdateSyncAction.Update_all_resources,_overwriting_local_changes_with_remote_contents_4"));
            this.radio1.setSelection(this.autoMerge);
            this.radio2.setSelection(!this.autoMerge);
            return composite;
        }

        public boolean getAutomerge() {
            return this.autoMerge;
        }

        static /* synthetic */ Button access$0(ConfirmDialog confirmDialog) {
            return confirmDialog.radio1;
        }

        static /* synthetic */ void access$1(ConfirmDialog confirmDialog, boolean bl) {
            confirmDialog.autoMerge = bl;
        }
    }
}

