/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncSet;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.UnchangedTeamContainer;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

abstract class MergeAction
extends Action {
    public static final int CHECKIN = 0;
    public static final int GET = 1;
    public static final int DELETE_REMOTE = 2;
    public static final int DELETE_LOCAL = 3;
    private CVSSyncCompareInput diffModel;
    private ISelectionProvider selectionProvider;
    protected int syncMode;
    private Shell shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MergeAction(CVSSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(label);
        this.diffModel = model;
        this.selectionProvider = sp;
        this.shell = shell;
        String helpContextId = this.getHelpContextID();
        if (helpContextId != null) {
            WorkbenchHelp.setHelp((IAction)this, (String)helpContextId);
        }
    }

    protected String getHelpContextID() {
        return null;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected CVSSyncCompareInput getDiffModel() {
        return this.diffModel;
    }

    private boolean isEnabled(Object[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            ITeamNode node;
            if (nodes[i] instanceof ITeamNode ? this.isEnabled(node = (ITeamNode)nodes[i]) : nodes[i] instanceof IDiffContainer && this.isEnabled(((IDiffContainer)nodes[i]).getChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract boolean isEnabled(ITeamNode var1);

    public void run() {
        ISelection s = this.selectionProvider.getSelection();
        if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
            return;
        }
        final CVSSyncSet set = new CVSSyncSet((IStructuredSelection)s);
        this.removeNonApplicableNodes(set, this.syncMode);
        final SyncSet[] result = new SyncSet[1];
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                result[0] = MergeAction.this.run(set, monitor);
            }
        };
        try {
            this.run((IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {}
        if (result[0] != null) {
            this.removeNodes(result[0].getChangedNodes());
            this.diffModel.updateView();
        }
    }

    protected abstract void removeNonApplicableNodes(SyncSet var1, int var2);

    private void removeNodes(ITeamNode[] nodes) {
        HashSet<Object> outgoingFolderDeletions = new HashSet<Object>();
        int i = 0;
        while (i < nodes.length) {
            block15: {
                block17: {
                    block16: {
                        Class<?> clazz = nodes[i].getClass();
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.team.internal.ui.sync.UnchangedTeamContainer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz2) break block15;
                        Class<?> clazz3 = nodes[i].getClass();
                        Class<?> clazz4 = class$1;
                        if (clazz4 == null) {
                            try {
                                clazz4 = Class.forName("org.eclipse.team.internal.ui.sync.ChangedTeamContainer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3 != clazz4) break block16;
                        ChangedTeamContainer container = (ChangedTeamContainer)nodes[i];
                        IDiffElement[] children = container.getChildren();
                        if (children.length <= 0) break block17;
                        if (this.isLocallyDeletedFolder((IDiffElement)container)) {
                            outgoingFolderDeletions.add(container);
                        } else {
                            IDiffContainer parent = container.getParent();
                            UnchangedTeamContainer unchanged = new UnchangedTeamContainer(parent, container.getResource());
                            int j = 0;
                            while (j < children.length) {
                                unchanged.add(children[j]);
                                ++j;
                            }
                            parent.removeToRoot((IDiffElement)container);
                        }
                        break block15;
                    }
                    Class<?> clazz = nodes[i].getParent().getClass();
                    Class<?> clazz5 = class$1;
                    if (clazz5 == null) {
                        try {
                            clazz5 = Class.forName("org.eclipse.team.internal.ui.sync.ChangedTeamContainer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz5 && this.isLocallyDeletedFolder((IDiffElement)nodes[i].getParent())) {
                        outgoingFolderDeletions.add(nodes[i].getParent());
                    }
                }
                nodes[i].getParent().removeToRoot((IDiffElement)nodes[i]);
            }
            ++i;
        }
        Iterator iter = outgoingFolderDeletions.iterator();
        while (iter.hasNext()) {
            this.removeLocallyDeletedFolder((ChangedTeamContainer)iter.next());
        }
    }

    public void update(int syncMode) {
        this.syncMode = syncMode;
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        this.setEnabled(this.isEnabled(selection.toArray()));
    }

    protected abstract SyncSet run(SyncSet var1, IProgressMonitor var2);

    protected void run(IRunnableWithProgress op) throws InterruptedException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
    }

    protected boolean saveIfNecessary() {
        return this.getDiffModel().saveIfNecessary();
    }

    protected boolean isLocallyDeletedFolder(IDiffElement element) {
        if (element.getType() != "FOLDER") {
            return false;
        }
        int kind = element.getKind();
        return (kind & 3) == 2 && (kind & 0xC) == 4 || (kind & 3) == 3 && (kind & 0xC) == 12;
    }

    protected void recreateLocallyDeletedFolder(IDiffElement element) throws TeamException {
        CVSRemoteSyncElement syncElement;
        ICVSFolder cvsFolder;
        if (element == null) {
            return;
        }
        if (element instanceof ChangedTeamContainer && !(cvsFolder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)(syncElement = (CVSRemoteSyncElement)((ChangedTeamContainer)element).getMergeResource().getSyncElement()).getLocal())).exists()) {
            this.recreateLocallyDeletedFolder((IDiffElement)element.getParent());
            cvsFolder.mkdir();
            syncElement.makeInSync(Policy.monitorFor(null));
            ((ChangedTeamContainer)element).makeInSync();
        }
    }

    private void removeLocallyDeletedFolder(ChangedTeamContainer container) {
        boolean hasIncoming = this.hasRealChanges((IDiffElement)container, new int[]{8});
        boolean hasOutgoing = this.hasRealChanges((IDiffElement)container, new int[]{4});
        boolean hasConflicting = this.hasRealChanges((IDiffElement)container, new int[]{12});
        IDiffContainer parent = container.getParent();
        if (hasConflicting || hasOutgoing && hasIncoming) {
            return;
        }
        if (hasOutgoing) {
            container.setKind(6);
        } else if (hasIncoming) {
            container.setKind(9);
        } else if (parent != null) {
            parent.removeToRoot((IDiffElement)container);
        }
        if (parent != null && this.isLocallyDeletedFolder((IDiffElement)parent)) {
            this.removeLocallyDeletedFolder((ChangedTeamContainer)parent);
        }
    }

    protected boolean hasRealChanges(IDiffElement node, int[] changeDirections) {
        int i;
        if (!this.isLocallyDeletedFolder(node)) {
            int direction = node.getKind() & 0xC;
            i = 0;
            while (i < changeDirections.length) {
                if (direction == changeDirections[i]) {
                    return true;
                }
                ++i;
            }
        }
        if (node.getType() == "FOLDER") {
            IDiffElement[] children = ((IDiffContainer)node).getChildren();
            i = 0;
            while (i < children.length) {
                if (this.hasRealChanges(children[i], changeDirections)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void makeInSync(IDiffElement parentElement) throws TeamException {
        ArrayList<IDiffElement> v = new ArrayList<IDiffElement>();
        int parentKind = parentElement.getKind();
        int direction = parentKind & 0xC;
        int change = parentKind & 3;
        while (change == 1 && (direction == 8 || direction == 12)) {
            v.add(0, parentElement);
            parentElement = parentElement.getParent();
            parentKind = parentElement == null ? 0 : parentElement.getKind();
            direction = parentKind & 0xC;
            change = parentKind & 3;
        }
        Iterator parentIt = ((AbstractList)v).iterator();
        while (parentIt.hasNext()) {
            IDiffElement next = (IDiffElement)parentIt.next();
            if (!(next instanceof ChangedTeamContainer)) continue;
            CVSRemoteSyncElement syncElement = (CVSRemoteSyncElement)((ChangedTeamContainer)next).getMergeResource().getSyncElement();
            syncElement.makeInSync(Policy.monitorFor(null));
            ((ChangedTeamContainer)next).setKind(0);
        }
    }

    protected void handle(Throwable t) {
        CVSUIPlugin.openError(this.getShell(), this.getErrorTitle(), null, t, 13);
    }

    protected String getErrorTitle() {
        return null;
    }
}

