/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.IgnoreResourcesDialog;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.TeamFile;
import org.eclipse.team.internal.ui.sync.UnchangedTeamContainer;
import org.eclipse.ui.help.WorkbenchHelp;

public class IgnoreAction
extends Action {
    Shell shell;
    private CVSSyncCompareInput diffModel;
    private ISelectionProvider selectionProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IgnoreAction(CVSSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(label);
        this.shell = shell;
        this.diffModel = model;
        this.selectionProvider = sp;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.team.cvs.ui.sync_ignore_action_context");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object first = selection.getFirstElement();
        ICVSFile cvsResource = null;
        IResource resource = null;
        if (first instanceof TeamFile) {
            resource = ((TeamFile)first).getMergeResource().getResource();
            cvsResource = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
        } else if (first instanceof ChangedTeamContainer) {
            resource = ((ChangedTeamContainer)first).getMergeResource().getResource();
            cvsResource = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)resource));
        }
        if (resource != null) {
            try {
                IgnoreResourcesDialog dialog = new IgnoreResourcesDialog(this.shell, new IResource[]{resource});
                if (dialog.open() != 0) {
                    return;
                }
                String pattern = dialog.getIgnorePatternFor(resource);
                cvsResource.setIgnoredAs(pattern);
            }
            catch (CVSException e) {
                CVSUIPlugin.openError(this.shell, null, null, e);
                return;
            }
            this.removeNodes(new SyncSet(selection).getChangedNodes());
            this.diffModel.refresh();
        }
    }

    protected boolean isEnabled(Object[] nodes) {
        if (nodes.length != 1) {
            return false;
        }
        if (!(nodes[0] instanceof ITeamNode)) {
            return false;
        }
        ITeamNode node = (ITeamNode)nodes[0];
        if (node.getKind() != 5) {
            return false;
        }
        IResource resource = node.getResource();
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        try {
            if (cvsResource.isManaged()) {
                return false;
            }
            if (cvsResource.isIgnored()) {
                return false;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log(e.getStatus());
            return false;
        }
        return true;
    }

    public void update() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        this.setEnabled(this.isEnabled(selection.toArray()));
    }

    private void removeNodes(ITeamNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            Class<?> clazz = nodes[i].getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.team.internal.ui.sync.UnchangedTeamContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ChangedTeamContainer container;
                IDiffElement[] children;
                Class<?> clazz3 = nodes[i].getClass();
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.team.internal.ui.sync.ChangedTeamContainer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 == clazz4 && (children = (container = (ChangedTeamContainer)nodes[i]).getChildren()).length > 0) {
                    IDiffContainer parent = container.getParent();
                    UnchangedTeamContainer unchanged = new UnchangedTeamContainer(parent, container.getResource());
                    int j = 0;
                    while (j < children.length) {
                        unchanged.add(children[j]);
                        ++j;
                    }
                    parent.removeToRoot((IDiffElement)container);
                } else {
                    nodes[i].getParent().removeToRoot((IDiffElement)nodes[i]);
                }
            }
            ++i;
        }
    }
}

