/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncSet;
import org.eclipse.team.internal.ccvs.ui.sync.MergeAction;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.TeamFile;

public class AddSyncAction
extends MergeAction {
    public AddSyncAction(CVSSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(model, sp, label, shell);
    }

    protected SyncSet run(SyncSet syncSet, IProgressMonitor monitor) {
        boolean result = this.saveIfNecessary();
        if (!result) {
            return null;
        }
        ITeamNode[] changed = syncSet.getChangedNodes();
        if (changed.length == 0) {
            return syncSet;
        }
        ArrayList<IResource> additions = new ArrayList<IResource>();
        try {
            int i = 0;
            while (i < changed.length) {
                int kind = changed[i].getKind();
                IResource resource = changed[i].getResource();
                if ((kind & 0xC) == 12) {
                    if (resource.getType() == 2) {
                        this.makeInSync((IDiffElement)changed[i]);
                    } else {
                        this.makeAdded(changed[i]);
                    }
                } else if (resource.getType() == 1) {
                    additions.add(resource);
                }
                ++i;
            }
            RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
            if (additions.size() != 0) {
                manager.add(additions.toArray(new IResource[0]), monitor);
            }
            int i2 = 0;
            while (i2 < changed.length) {
                ITeamNode node = changed[i2];
                IResource resource = changed[i2].getResource();
                if (resource.getType() == 1) {
                    syncSet.remove(node);
                }
                ++i2;
            }
        }
        catch (TeamException e) {
            this.handle(e);
            return null;
        }
        return syncSet;
    }

    protected void makeAdded(ITeamNode changed) throws TeamException, CVSException {
        this.makeInSync((IDiffElement)changed.getParent());
        CVSRemoteSyncElement syncElement = (CVSRemoteSyncElement)((TeamFile)changed).getMergeResource().getSyncElement();
        ICVSResource remote = (ICVSResource)syncElement.getRemote();
        MutableResourceSyncInfo info = remote.getSyncInfo().cloneMutable();
        info.setTimeStamp(null);
        info.setAdded();
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)changed.getResource()));
        cvsFile.setSyncInfo((ResourceSyncInfo)info, 0);
    }

    protected boolean isEnabled(ITeamNode node) {
        try {
            CVSSyncSet set = new CVSSyncSet((IStructuredSelection)new StructuredSelection((Object)node));
            set.removeConflictingNodes();
            return set.hasNonAddedChanges();
        }
        catch (CVSException e) {
            CVSUIPlugin.log(e.getStatus());
            return false;
        }
    }

    protected void removeNonApplicableNodes(SyncSet set, int syncMode) {
        set.removeIncomingNodes();
        set.removeConflictingNodes();
        ((CVSSyncSet)set).removeAddedChanges();
    }

    protected String getHelpContextID() {
        return "org.eclipse.team.cvs.ui.sync_add_action_context";
    }

    protected String getErrorTitle() {
        return Policy.bind("AddAction.addFailed");
    }
}

