/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.XMLWriter;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesViewContentHandler;

public class RepositoryRoot
extends PlatformObject {
    public static final String[] DEFAULT_AUTO_REFRESH_FILES = new String[]{".project", ".vcm_meta"};
    private static final String DEFINED_MODULE_PREFIX = "module:";
    ICVSRepositoryLocation root;
    String name;
    Map knownTags = new HashMap();
    Map autoRefreshFiles = new HashMap();
    Map modulesCache;
    static /* synthetic */ Class class$0;

    public RepositoryRoot(ICVSRepositoryLocation root) {
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public ICVSRemoteFolder getRemoteFolder(String path, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        if (RepositoryRoot.isDefinedModuleName(path)) {
            return this.getDefinedModule(RepositoryRoot.getDefinedModuleName(path), tag, monitor);
        }
        return this.root.getRemoteFolder(path, tag);
    }

    static boolean isDefinedModuleName(String path) {
        return path.startsWith(DEFINED_MODULE_PREFIX);
    }

    static String getDefinedModuleName(String path) {
        return path.substring(DEFINED_MODULE_PREFIX.length());
    }

    static String asDefinedModulePath(String path) {
        return DEFINED_MODULE_PREFIX + path;
    }

    private ICVSRemoteFolder getDefinedModule(String path, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        ICVSRemoteFolder folder = (ICVSRemoteFolder)cache.get(path);
        if (folder != null) {
            folder = (ICVSRemoteFolder)folder.forTag(tag);
        }
        return folder;
    }

    private Map getDefinedModulesCache(CVSTag tag, IProgressMonitor monitor) throws CVSException {
        if (this.modulesCache == null) {
            this.modulesCache = new HashMap();
            try {
                ICVSRemoteResource[] folders = this.root.members(CVSTag.DEFAULT, true, monitor);
                int i = 0;
                while (i < folders.length) {
                    ICVSRemoteResource resource = folders[i];
                    this.modulesCache.put(resource.getName(), resource);
                    ++i;
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((TeamException)((Object)e));
            }
        }
        return this.modulesCache;
    }

    public ICVSRemoteResource[] getDefinedModules(CVSTag tag, IProgressMonitor monitor) throws CVSException {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        return cache.values().toArray(new ICVSRemoteResource[cache.size()]);
    }

    public static String getRemotePathFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSRemoteFolder remoteFolder;
            if (resource instanceof ICVSRemoteFolder && (remoteFolder = (ICVSRemoteFolder)resource).isDefinedModule()) {
                return RepositoryRoot.asDefinedModulePath(remoteFolder.getName());
            }
            FolderSyncInfo info = ((ICVSFolder)resource).getFolderSyncInfo();
            if (info == null) {
                throw new CVSException(Policy.bind("RepositoryRoot.folderInfoMissing", resource.getName()));
            }
            return info.getRepository();
        }
        FolderSyncInfo info = resource.getParent().getFolderSyncInfo();
        if (info == null) {
            throw new CVSException(Policy.bind("RepositoryRoot.folderInfoMissing", resource.getParent().getName()));
        }
        String path = new Path(info.getRepository()).append(resource.getName()).toString();
        return path;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addTags(String remotePath, CVSTag[] tags) {
        String name = this.getCachePathFor(remotePath);
        HashSet<CVSTag> set = (HashSet<CVSTag>)this.knownTags.get(name);
        if (set == null) {
            set = new HashSet<CVSTag>();
            this.knownTags.put(name, set);
        }
        int i = 0;
        while (i < tags.length) {
            set.add(tags[i]);
            ++i;
        }
    }

    public void removeTags(String remotePath, CVSTag[] tags) {
        String name = this.getCachePathFor(remotePath);
        Set set = (Set)this.knownTags.get(name);
        if (set == null) {
            return;
        }
        int i = 0;
        while (i < tags.length) {
            set.remove(tags[i]);
            ++i;
        }
    }

    public String[] getAutoRefreshFiles(String remotePath) {
        String name = this.getCachePathFor(remotePath);
        Set files = (Set)this.autoRefreshFiles.get(name);
        if (files == null || files.isEmpty()) {
            if (RepositoryRoot.isDefinedModuleName(remotePath)) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < DEFAULT_AUTO_REFRESH_FILES.length) {
                String relativePath = DEFAULT_AUTO_REFRESH_FILES[i];
                result.add(new Path(remotePath).append(relativePath).toString());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public void setAutoRefreshFiles(String remotePath, String[] autoRefreshFiles) {
        HashSet<String> newFiles = new HashSet<String>(Arrays.asList(autoRefreshFiles));
        if (autoRefreshFiles.length == DEFAULT_AUTO_REFRESH_FILES.length) {
            boolean isDefault = true;
            int i = 0;
            while (i < DEFAULT_AUTO_REFRESH_FILES.length) {
                String filePath = DEFAULT_AUTO_REFRESH_FILES[i];
                if (!newFiles.contains(new Path(remotePath).append(filePath).toString())) {
                    isDefault = false;
                    break;
                }
                ++i;
            }
            if (isDefault) {
                this.autoRefreshFiles.remove(this.getCachePathFor(remotePath));
                return;
            }
        }
        this.autoRefreshFiles.put(this.getCachePathFor(remotePath), newFiles);
    }

    public void refreshDefinedTags(String remotePath, boolean replace, IProgressMonitor monitor) throws TeamException {
        String[] filesToRefresh = this.getAutoRefreshFiles(remotePath);
        monitor.beginTask(null, filesToRefresh.length * 10);
        try {
            ArrayList<CVSTag> tags = new ArrayList<CVSTag>();
            int i = 0;
            while (i < filesToRefresh.length) {
                ICVSRemoteFile file = this.root.getRemoteFile(filesToRefresh[i], CVSTag.DEFAULT);
                tags.addAll(Arrays.asList(this.fetchTags(file, Policy.subMonitorFor(monitor, 5))));
                ++i;
            }
            if (!tags.isEmpty()) {
                this.addTags(remotePath, tags.toArray(new CVSTag[tags.size()]));
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        Object var8_10 = null;
        monitor.done();
    }

    private void clearTags(String remotePath) {
        String name = this.getCachePathFor(remotePath);
        this.knownTags.remove(name);
    }

    private CVSTag[] fetchTags(ICVSRemoteFile file, IProgressMonitor monitor) throws TeamException {
        try {
            HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
            ILogEntry[] entries = file.getLogEntries(monitor);
            int j = 0;
            while (j < entries.length) {
                CVSTag[] tags = entries[j].getTags();
                int k = 0;
                while (k < tags.length) {
                    tagSet.add(tags[k]);
                    ++k;
                }
                ++j;
            }
            return tagSet.toArray(new CVSTag[0]);
        }
        catch (TeamException e) {
            IStatus[] children;
            IStatus status = e.getStatus();
            if (status.getCode() == -10 && status.isMultiStatus() && (children = status.getChildren()).length == 1 && children[0].getCode() == -17) {
                return new CVSTag[0];
            }
            throw e;
        }
    }

    private String getCachePathFor(String remotePath) {
        String root = new Path(remotePath).segment(0);
        if (RepositoryRoot.isDefinedModuleName(remotePath)) {
            return RepositoryRoot.asDefinedModulePath(root);
        }
        return root;
    }

    public void writeState(XMLWriter writer) throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.clear();
        attributes.put("id", this.root.getLocation());
        String programName = ((CVSRepositoryLocation)this.root).getRemoteCVSProgramName();
        if (!programName.equals("cvs")) {
            attributes.put("program-name", programName);
        }
        if (this.name != null) {
            attributes.put("name", this.name);
        }
        writer.startTag("repository", attributes, true);
        String[] paths = this.getKnownRemotePaths();
        int i = 0;
        while (i < paths.length) {
            Set refreshSet;
            String path = paths[i];
            attributes.clear();
            String name = path;
            if (RepositoryRoot.isDefinedModuleName(path)) {
                name = RepositoryRoot.getDefinedModuleName(path);
                attributes.put("type", "defined");
            }
            attributes.put("path", name);
            writer.startTag("module", attributes, true);
            Set tagSet = (Set)this.knownTags.get(path);
            if (tagSet != null) {
                Iterator tagIt = tagSet.iterator();
                while (tagIt.hasNext()) {
                    CVSTag tag = (CVSTag)tagIt.next();
                    attributes.clear();
                    attributes.put("name", tag.getName());
                    attributes.put("type", RepositoriesViewContentHandler.TAG_TYPES[tag.getType()]);
                    writer.startAndEndTag("tag", attributes, true);
                }
            }
            if ((refreshSet = (Set)this.autoRefreshFiles.get(path)) != null) {
                Iterator filenameIt = refreshSet.iterator();
                while (filenameIt.hasNext()) {
                    String filename = (String)filenameIt.next();
                    attributes.clear();
                    attributes.put("full-path", filename);
                    writer.startAndEndTag("auto-refresh-file", attributes, true);
                }
            }
            writer.endTag("module");
            ++i;
        }
        writer.endTag("repository");
    }

    public CVSTag[] getKnownTags(String remotePath) {
        Set tagSet = (Set)this.knownTags.get(this.getCachePathFor(remotePath));
        if (tagSet == null) {
            return new CVSTag[0];
        }
        return tagSet.toArray(new CVSTag[tagSet.size()]);
    }

    public String[] getKnownRemotePaths() {
        HashSet paths = new HashSet();
        paths.addAll(this.knownTags.keySet());
        paths.addAll(this.autoRefreshFiles.keySet());
        return paths.toArray(new String[paths.size()]);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getRoot();
        }
        return super.getAdapter(adapter);
    }

    public ICVSRemoteResource[] filterResources(ICVSRemoteResource[] resource) {
        ArrayList<ICVSRemoteFolder> result = new ArrayList<ICVSRemoteFolder>();
        int i = 0;
        while (i < resource.length) {
            ICVSRemoteResource remoteResource = resource[i];
            if (remoteResource instanceof ICVSRemoteFolder) {
                ICVSRemoteFolder folder = (ICVSRemoteFolder)remoteResource;
                if (this.tagIsKnown(remoteResource)) {
                    result.add(folder);
                }
            }
            ++i;
        }
        return result.toArray(new ICVSRemoteResource[result.size()]);
    }

    public boolean tagIsKnown(ICVSRemoteResource remoteResource) {
        if (remoteResource instanceof ICVSRemoteFolder) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)remoteResource;
            String path = this.getCachePathFor(folder.getRepositoryRelativePath());
            CVSTag[] tags = this.getKnownTags(path);
            CVSTag tag = folder.getTag();
            int i = 0;
            while (i < tags.length) {
                CVSTag knownTag = tags[i];
                if (knownTag.equals((Object)tag)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void clearCache() {
        this.modulesCache = null;
    }

    void setRepositoryLocation(ICVSRepositoryLocation root) {
        this.root = root;
    }
}

