/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ui.DetailsDialogWithProjects;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RemoveRootAction
extends SelectionListenerAction {
    private IStructuredSelection selection;
    private Shell shell;
    static /* synthetic */ Class class$0;

    public RemoveRootAction(Shell shell) {
        super(Policy.bind("RemoteRootAction.label"));
        this.shell = shell;
    }

    protected ICVSRepositoryLocation[] getSelectedRemoteRoots() {
        ArrayList<Object> resources = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next;
                Object e = elements.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((next = CVSAction.getAdapter(e, clazz)) instanceof ICVSRepositoryLocation)) continue;
                resources.add(next);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ICVSRepositoryLocation[] result = new ICVSRepositoryLocation[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ICVSRepositoryLocation[0];
    }

    protected String getErrorTitle() {
        return Policy.bind("RemoveRootAction.removeRoot_3");
    }

    public void run() {
        ICVSRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        if (roots.length == 0) {
            return;
        }
        CVSProviderPlugin provider = CVSProviderPlugin.getPlugin();
        int i = 0;
        while (i < roots.length) {
            try {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                final ArrayList<IProject> shared = new ArrayList<IProject>();
                int j = 0;
                while (j < projects.length) {
                    CVSTeamProvider cvsProvider;
                    RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)projects[j], (String)CVSProviderPlugin.getTypeId());
                    if (teamProvider != null && (cvsProvider = (CVSTeamProvider)teamProvider).getCVSWorkspaceRoot().getRemoteLocation().equals(roots[i])) {
                        shared.add(projects[j]);
                    }
                    ++j;
                }
                if (!shared.isEmpty()) {
                    final String location = roots[i].getLocation();
                    this.shell.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            DetailsDialogWithProjects dialog = new DetailsDialogWithProjects(RemoveRootAction.this.shell, Policy.bind("RemoteRootAction.Unable_to_Discard_Location_1"), Policy.bind("RemoteRootAction.Projects_in_the_local_workspace_are_shared_with__2", location), Policy.bind("RemoteRootAction.The_projects_that_are_shared_with_the_above_repository_are__4"), shared.toArray(new IProject[shared.size()]), false, "dialog_error_image");
                            dialog.open();
                        }
                    });
                } else {
                    provider.disposeRepository(roots[i]);
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((TeamException)((Object)e));
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        ICVSRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        return roots.length > 0;
    }
}

