/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ui.DetailsDialogWithProjects;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSRepositoryPropertiesPage
extends PropertyPage {
    ICVSRepositoryLocation location;
    Text userText;
    Text passwordText;
    Combo methodType;
    Label hostLabel;
    Label pathLabel;
    Label portLabel;
    boolean passwordChanged;
    boolean connectionInfoChanged;
    boolean programNameChanged;
    boolean labelChanged;
    IUserInfo info;
    private Text programNameText;
    private Button useDefaultProgramName;
    private Button useCustomProgramName;
    private Button useLocationAsLabel;
    private Button useCustomLabel;
    private Text labelText;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Composite labelGroup = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        labelGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        labelGroup.setLayout((Layout)layout);
        Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.labelChanged = true;
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        };
        this.useLocationAsLabel = this.createRadioButton(labelGroup, Policy.bind("CVSRepositoryPropertiesPage.useLocationAsLabel"), 3);
        this.useCustomLabel = this.createRadioButton(labelGroup, Policy.bind("CVSRepositoryPropertiesPage.useCustomLabel"), 1);
        this.useCustomLabel.addListener(13, labelListener);
        this.labelText = this.createTextField(labelGroup);
        this.labelText.addListener(24, labelListener);
        this.createLabel(composite, "", 3);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.connectionType"), 1);
        this.methodType = this.createCombo(composite);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.user"), 1);
        this.userText = this.createTextField(composite);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.password"), 1);
        this.passwordText = this.createTextField(composite);
        this.passwordText.setEchoChar('*');
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.host"), 1);
        this.hostLabel = this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.port"), 1);
        this.portLabel = this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.path"), 1);
        this.pathLabel = this.createLabel(composite, "", 2);
        this.createLabel(composite, "", 3);
        Composite programNameGroup = new Composite(composite, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        programNameGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        programNameGroup.setLayout((Layout)layout);
        Listener programNameListener = new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.programNameChanged = true;
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        };
        this.useDefaultProgramName = this.createRadioButton(programNameGroup, Policy.bind("CVSRepositoryPropertiesPage.useDefaultProgramName"), 3);
        this.useCustomProgramName = this.createRadioButton(programNameGroup, Policy.bind("CVSRepositoryPropertiesPage.useProgramName"), 1);
        this.useCustomProgramName.addListener(13, programNameListener);
        this.programNameText = this.createTextField(programNameGroup);
        this.programNameText.addListener(24, programNameListener);
        this.initializeValues();
        this.updateWidgetEnablements();
        this.passwordText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.passwordChanged = true;
            }
        });
        this.userText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.connectionInfoChanged = true;
            }
        });
        this.methodType.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.connectionInfoChanged = true;
            }
        });
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.repository_location_property_page_context");
        return composite;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        this.location = null;
        IAdaptable element = this.getElement();
        if (element instanceof ICVSRepositoryLocation) {
            this.location = (ICVSRepositoryLocation)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof ICVSRepositoryLocation) {
                this.location = (ICVSRepositoryLocation)adapter;
            }
        }
    }

    private void initializeValues() {
        this.passwordChanged = false;
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            this.methodType.add(methods[i].getName());
            ++i;
        }
        String method = this.location.getMethod().getName();
        this.methodType.select(this.methodType.indexOf(method));
        this.info = this.location.getUserInfo(true);
        this.userText.setText(this.info.getUsername());
        this.passwordText.setText("*********");
        this.hostLabel.setText(this.location.getHost());
        int port = this.location.getPort();
        if (port == 0) {
            this.portLabel.setText(Policy.bind("CVSPropertiesPage.defaultPort"));
        } else {
            this.portLabel.setText("" + port);
        }
        this.pathLabel.setText(this.location.getRootDirectory());
        String programName = ((CVSRepositoryLocation)this.location).getRemoteCVSProgramName();
        this.programNameText.setText(programName);
        this.useDefaultProgramName.setSelection(programName == "cvs");
        this.useCustomProgramName.setSelection(!this.useDefaultProgramName.getSelection());
        String label = null;
        RepositoryRoot root = CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor(this.location);
        label = root.getName();
        this.useLocationAsLabel.setSelection(label == null);
        this.useCustomLabel.setSelection(!this.useLocationAsLabel.getSelection());
        if (label == null) {
            label = this.location.getLocation();
        }
        this.labelText.setText(label);
    }

    public boolean performOk() {
        if (!this.connectionInfoChanged && !this.passwordChanged) {
            if (this.programNameChanged) {
                this.recordNewProgramName((CVSRepositoryLocation)this.location);
            }
            if (this.labelChanged) {
                this.recordNewLabel((CVSRepositoryLocation)this.location);
            }
            return true;
        }
        this.info.setUsername(this.userText.getText());
        if (this.passwordChanged) {
            this.info.setPassword(this.passwordText.getText());
        }
        final String type = this.methodType.getText();
        final String password = this.passwordText.getText();
        final boolean[] result = new boolean[1];
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CVSRepositoryLocation newLocation;
                        block15: {
                            block14: {
                                if (CVSRepositoryPropertiesPage.this.passwordChanged && !CVSRepositoryPropertiesPage.this.connectionInfoChanged) {
                                    CVSRepositoryLocation oldLocation = (CVSRepositoryLocation)CVSRepositoryPropertiesPage.this.location;
                                    oldLocation.setPassword(password);
                                    oldLocation.updateCache();
                                    CVSRepositoryPropertiesPage.this.passwordChanged = false;
                                    result[0] = true;
                                    return;
                                }
                                newLocation = CVSRepositoryLocation.fromString((String)CVSRepositoryPropertiesPage.this.location.getLocation());
                                newLocation.setMethod(type);
                                newLocation.setUserInfo(CVSRepositoryPropertiesPage.this.info);
                                try {
                                    block13: {
                                        ArrayList<IProject> projects = new ArrayList<IProject>();
                                        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                        int i = 0;
                                        while (true) {
                                            CVSTeamProvider cvsProvider;
                                            if (i >= allProjects.length) {
                                                if (projects.size() <= 0) break block13;
                                                DetailsDialogWithProjects dialog = new DetailsDialogWithProjects(CVSRepositoryPropertiesPage.this.getShell(), Policy.bind("CVSRepositoryPropertiesPage.Confirm_Project_Sharing_Changes_1"), Policy.bind("CVSRepositoryPropertiesPage.There_are_projects_in_the_workspace_shared_with_this_repository_2"), Policy.bind("CVSRepositoryPropertiesPage.sharedProject", CVSRepositoryPropertiesPage.this.location.toString()), projects.toArray(new IProject[projects.size()]), true, "dialog_warning_image");
                                                int r = dialog.open();
                                                if (r == 0) break;
                                                result[0] = false;
                                                Object var13_12 = null;
                                                break block14;
                                            }
                                            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)allProjects[i], (String)CVSProviderPlugin.getTypeId());
                                            if (teamProvider != null && (cvsProvider = (CVSTeamProvider)teamProvider).getCVSWorkspaceRoot().getRemoteLocation().equals(CVSRepositoryPropertiesPage.this.location)) {
                                                projects.add(allProjects[i]);
                                            }
                                            ++i;
                                        }
                                        monitor.beginTask(null, 1000 * projects.size());
                                        try {
                                            Iterator it = projects.iterator();
                                            while (it.hasNext()) {
                                                IProject project = (IProject)it.next();
                                                RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                                                CVSTeamProvider cvsProvider = (CVSTeamProvider)teamProvider;
                                                cvsProvider.setRemoteRoot((ICVSRepositoryLocation)newLocation, Policy.subMonitorFor(monitor, 1000));
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_19 = null;
                                            monitor.done();
                                            throw throwable;
                                        }
                                        Object var11_20 = null;
                                        monitor.done();
                                    }
                                    CVSUIPlugin.getPlugin().getRepositoryManager().replaceRepositoryLocation(CVSRepositoryPropertiesPage.this.location, newLocation);
                                    break block15;
                                }
                                catch (Throwable throwable) {
                                    Object var13_13 = null;
                                    newLocation = (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(newLocation.getLocation());
                                    newLocation.updateCache();
                                    throw throwable;
                                }
                            }
                            newLocation = (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(newLocation.getLocation());
                            newLocation.updateCache();
                            return;
                        }
                        Object var13_14 = null;
                        newLocation = (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(newLocation.getLocation());
                        newLocation.updateCache();
                        CVSRepositoryPropertiesPage.this.location = newLocation;
                        if (CVSRepositoryPropertiesPage.this.programNameChanged) {
                            CVSRepositoryPropertiesPage.this.recordNewProgramName((CVSRepositoryLocation)CVSRepositoryPropertiesPage.this.location);
                        }
                        if (CVSRepositoryPropertiesPage.this.labelChanged) {
                            CVSRepositoryPropertiesPage.this.recordNewLabel((CVSRepositoryLocation)CVSRepositoryPropertiesPage.this.location);
                        }
                        CVSRepositoryPropertiesPage.this.connectionInfoChanged = false;
                        CVSRepositoryPropertiesPage.this.passwordChanged = false;
                        CVSRepositoryPropertiesPage.this.programNameChanged = false;
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                    result[0] = true;
                }
            });
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    protected void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), null, null, e);
    }

    protected void updateWidgetEnablements() {
        if (this.useDefaultProgramName.getSelection()) {
            this.programNameText.setEnabled(false);
        } else {
            this.programNameText.setEnabled(true);
        }
        if (this.useLocationAsLabel.getSelection()) {
            this.labelText.setEnabled(false);
        } else {
            this.labelText.setEnabled(true);
        }
        this.validateFields();
    }

    private void validateFields() {
        if (this.programNameText.isEnabled() && this.programNameText.getText().length() == 0) {
            this.setValid(false);
            return;
        }
        if (this.labelText.isEnabled() && this.labelText.getText().length() == 0) {
            this.setValid(false);
            return;
        }
        this.setValid(true);
    }

    private void recordNewProgramName(CVSRepositoryLocation location) {
        String newProgramName = this.useDefaultProgramName.getSelection() ? "cvs" : this.programNameText.getText();
        if (!location.getRemoteCVSProgramName().equals(newProgramName)) {
            CVSProviderPlugin.getPlugin().setCVSProgramName((ICVSRepositoryLocation)location, newProgramName);
        }
    }

    private void recordNewLabel(CVSRepositoryLocation location) {
        String label = null;
        if (this.useCustomLabel.getSelection() && (label = this.labelText.getText()).equals(location.getLocation())) {
            label = null;
        }
        try {
            CVSUIPlugin.getPlugin().getRepositoryManager().setLabel(location, label);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((TeamException)((Object)e));
        }
    }
}

