/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteModule;
import org.eclipse.ui.IWorkingSet;

public class VersionCategory
extends CVSModelElement
implements IAdaptable {
    private ICVSRepositoryLocation repository;
    static /* synthetic */ Class class$0;

    public VersionCategory(ICVSRepositoryLocation repo) {
        this.repository = repo;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public Object[] internalGetChildren(Object o, IWorkingSet set, IProgressMonitor monitor) throws TeamException {
        if (CVSUIPlugin.getPlugin().getRepositoryManager().isDisplayingProjectVersions(this.repository)) {
            return this.getProjectVersionChildren(o, set, monitor);
        }
        return this.getVersionTagChildren(o, set, monitor);
    }

    public Object[] internalGetChildren(Object o, IProgressMonitor monitor) throws TeamException {
        return this.internalGetChildren(o, null, monitor);
    }

    private Object[] getVersionTagChildren(Object o, IWorkingSet set, IProgressMonitor monitor) throws CVSException {
        CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(this.repository, set, 2, monitor);
        Object[] versionElements = new CVSTagElement[tags.length];
        int i = 0;
        while (i < tags.length) {
            versionElements[i] = new CVSTagElement(tags[i], this.repository);
            ++i;
        }
        return versionElements;
    }

    private Object[] getProjectVersionChildren(Object o, IWorkingSet set, IProgressMonitor monitor) throws TeamException {
        CVSUIPlugin.getPlugin().getPreferenceStore();
        ICVSRemoteResource[] resources = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(this.repository, CVSTag.DEFAULT, monitor);
        if (set != null) {
            resources = CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(set, resources);
        }
        Object[] modules = new Object[resources.length];
        int i = 0;
        while (i < resources.length) {
            modules[i] = new RemoteModule((ICVSRemoteFolder)resources[i], this);
            ++i;
        }
        return modules;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/versions_rep.gif");
    }

    public String getLabel(Object o) {
        return Policy.bind("VersionCategory.Versions_1");
    }

    public Object getParent(Object o) {
        return this.repository;
    }

    public ICVSRepositoryLocation getRepository(Object o) {
        return this.repository;
    }

    public boolean isNeedsProgress() {
        return true;
    }
}

