/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.merge;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.merge.MergeEditorInput;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ccvs.ui.sync.UpdateSyncAction;
import org.eclipse.team.internal.ui.sync.ITeamNode;

public class UpdateMergeAction
extends UpdateSyncAction {
    public UpdateMergeAction(CVSSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(model, sp, label, shell);
    }

    protected void runUpdateDeletions(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        this.runUpdateDeep(nodes, manager, monitor);
    }

    protected void runUpdateDeep(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        ITeamNode[] incoming = this.removeOutgoing(nodes);
        monitor.beginTask(null, 1000 * incoming.length);
        try {
            int i = 0;
            while (i < incoming.length) {
                CVSRemoteSyncElement element = CVSSyncCompareInput.getSyncElementFrom(incoming[i]);
                if (element != null) {
                    this.makeRemoteLocal(element, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        Object var7_9 = null;
        monitor.done();
    }

    protected void runUpdateIgnoreLocalShallow(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        this.runUpdateDeep(nodes, manager, monitor);
    }

    protected void runUpdateShallow(ITeamNode[] nodes, RepositoryManager manager, IProgressMonitor monitor) throws TeamException {
        this.mergeWithLocal(nodes, manager, false, monitor);
    }

    protected void mergeWithLocal(ITeamNode[] nodes, RepositoryManager manager, boolean createBackup, IProgressMonitor monitor) throws TeamException {
        CVSTag startTag = ((MergeEditorInput)this.getDiffModel()).getStartTag();
        CVSTag endTag = ((MergeEditorInput)this.getDiffModel()).getEndTag();
        Command.LocalOption[] options = new Command.LocalOption[]{Command.DO_NOT_RECURSE, Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)startTag.getName()), Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName())};
        manager.update(this.getIResourcesFrom(nodes), options, createBackup, monitor);
    }

    private ITeamNode[] removeOutgoing(ITeamNode[] nodes) {
        return nodes;
    }

    private void makeRemoteLocal(CVSRemoteSyncElement element, IProgressMonitor monitor) throws CVSException {
        block11: {
            IRemoteResource remote = element.getRemote();
            IResource local = element.getLocal();
            try {
                if (remote == null) {
                    local.delete(false, monitor);
                    break block11;
                }
                if (remote.isContainer()) {
                    if (!local.exists()) {
                        ((IFolder)local).create(false, true, monitor);
                    }
                    break block11;
                }
                monitor.beginTask(null, 200);
                try {
                    IFile localFile = (IFile)local;
                    if (local.exists()) {
                        localFile.setContents(remote.getContents(Policy.subMonitorFor(monitor, 100)), false, true, Policy.subMonitorFor(monitor, 100));
                    } else {
                        if (!localFile.getParent().exists()) {
                            this.ensureParentExists((IResource)localFile);
                        }
                        localFile.create(remote.getContents(Policy.subMonitorFor(monitor, 100)), false, Policy.subMonitorFor(monitor, 100));
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var6_10 = null;
                monitor.done();
            }
            catch (CoreException e) {
                throw new CVSException(Policy.bind("UpdateMergeActionProblems_merging_remote_resources_into_workspace_1"), (Throwable)e);
            }
            catch (TeamException e) {
                throw new CVSException(Policy.bind("UpdateMergeActionProblems_merging_remote_resources_into_workspace_2"), (Throwable)e);
            }
        }
    }

    private void ensureParentExists(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (!parent.exists()) {
            this.ensureParentExists((IResource)parent);
            IFolder folder = (IFolder)parent;
            folder.create(false, true, null);
        }
    }

    protected String getHelpContextID() {
        return "org.eclipse.team.cvs.ui.merge_update_action_context";
    }
}

