/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.merge;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagRootElement;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProjectElement
implements IAdaptable,
IWorkbenchAdapter {
    ICVSFolder project;
    TagRootElement branches;
    TagRootElement versions;
    int includeFlags;
    public static final int INCLUDE_HEAD_TAG = 1;
    public static final int INCLUDE_BASE_TAG = 2;
    public static final int INCLUDE_BRANCHES = 4;
    public static final int INCLUDE_VERSIONS = 8;
    public static final int INCLUDE_ALL_TAGS = 15;
    static /* synthetic */ Class class$0;

    public ProjectElement(ICVSFolder project, int includeFlags) {
        this.project = project;
        this.includeFlags = includeFlags;
        if (this.includeFlags == 0) {
            this.includeFlags = 15;
        }
        if ((includeFlags & 4) > 0) {
            this.branches = new TagRootElement(project, 1);
        }
        if ((includeFlags & 8) > 0) {
            this.versions = new TagRootElement(project, 2);
        }
    }

    public Object[] getChildren(Object o) {
        ArrayList<Object> children = new ArrayList<Object>(4);
        if ((this.includeFlags & 1) > 0) {
            children.add(new TagElement(CVSTag.DEFAULT));
        }
        if ((this.includeFlags & 2) > 0) {
            children.add(new TagElement(CVSTag.BASE));
        }
        if ((this.includeFlags & 4) > 0) {
            children.add(this.branches);
        }
        if ((this.includeFlags & 8) > 0) {
            children.add(this.versions);
        }
        return children.toArray(new Object[children.size()]);
    }

    public int getIncludeFlags() {
        return this.includeFlags;
    }

    public TagRootElement getBranches() {
        return this.branches;
    }

    public TagRootElement getVersions() {
        return this.versions;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public static class ProjectElementSorter
    extends ViewerSorter {
        public int category(Object element) {
            if (element instanceof TagElement) {
                CVSTag tag = ((TagElement)element).getTag();
                if (tag == CVSTag.DEFAULT) {
                    return 1;
                }
                if (tag == CVSTag.BASE) {
                    return 4;
                }
                if (tag.getType() == 1) {
                    return 2;
                }
                if (tag.getType() == 2) {
                    return 3;
                }
            } else if (element instanceof TagRootElement) {
                return ((TagRootElement)element).getTypeOfTagRoot() == 1 ? 2 : 3;
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof TagElement && ((TagElement)e1).getTag().getType() == 2) {
                return -1 * super.compare(viewer, e1, e2);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

