/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.merge;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.merge.MergeEditorInput;
import org.eclipse.team.internal.ccvs.ui.merge.MergeWizardEndPage;
import org.eclipse.team.internal.ccvs.ui.merge.MergeWizardStartPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MergeWizard
extends Wizard {
    MergeWizardStartPage startPage;
    MergeWizardEndPage endPage;
    IResource[] resources;

    public void addPages() {
        IProject projectForTagRetrieval = this.resources[0].getProject();
        this.setWindowTitle(Policy.bind("MergeWizard.title"));
        ImageDescriptor mergeImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/mergestream_wizban.gif");
        this.startPage = new MergeWizardStartPage("startPage", Policy.bind("MergeWizard.start"), mergeImage);
        this.startPage.setProject(projectForTagRetrieval);
        this.addPage((IWizardPage)this.startPage);
        this.endPage = new MergeWizardEndPage("endPage", Policy.bind("MergeWizard.end"), mergeImage, this.startPage);
        this.endPage.setProject(projectForTagRetrieval);
        this.addPage((IWizardPage)this.endPage);
    }

    public boolean performFinish() {
        IWorkbenchWindow wWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = null;
        if (wWindow != null) {
            activePage = wWindow.getActivePage();
        }
        CVSTag startTag = this.startPage.getTag();
        CVSTag endTag = this.endPage.getTag();
        CompareUI.openCompareEditorOnPage((CompareEditorInput)new MergeEditorInput(this.resources, startTag, endTag), (IWorkbenchPage)activePage);
        return true;
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
    }
}

