/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.TagAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;

public class TagInRepositoryAction
extends TagAction {
    protected boolean isEnabled() throws TeamException {
        ICVSResource[] resources = this.getSelectedCVSResources();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof ICVSRepositoryLocation) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ICVSResource[] resources = this.getSelectedCVSResources();
        final CVSTag[] tag = new CVSTag[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                ICVSFolder[] folders = new ICVSFolder[resources.length];
                int i = 0;
                while (i < resources.length) {
                    folders[i] = resources[i].isFolder() ? (ICVSFolder)resources[i] : resources[i].getParent();
                    ++i;
                }
                tag[0] = TagInRepositoryAction.this.promptForTag(folders);
            }
        });
        if (tag[0] == null) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(null, 1000 * resources.length);
                    RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                    int i = 0;
                    while (i < resources.length) {
                        IStatus status = ((ICVSRemoteResource)resources[i]).tag(tag[0], TagInRepositoryAction.this.getLocalOptions(), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        TagInRepositoryAction.this.addStatus(status);
                        try {
                            manager.addTags(TagInRepositoryAction.this.getRootParent(resources[i]), new CVSTag[]{tag[0]});
                        }
                        catch (CVSException e) {
                            TagInRepositoryAction.this.addStatus(e.getStatus());
                        }
                        ++i;
                    }
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
    }

    protected CVSTag promptForTag(ICVSFolder[] folders) {
        String name = this.promptForTag(folders[0]);
        if (name == null) {
            return null;
        }
        return new CVSTag(name, 2);
    }

    protected Command.LocalOption[] getLocalOptions() {
        return Command.NO_LOCAL_OPTIONS;
    }

    protected IStatus getStatusToDisplay(IStatus[] problems) {
        IStatus[] status = this.getAccumulatedStatus();
        int resourceCount = status.length;
        MultiStatus combinedStatus = resourceCount == 1 ? new MultiStatus("org.eclipse.team.cvs.ui", 0, Policy.bind("TagInRepositoryAction.tagProblemsMessage"), null) : new MultiStatus("org.eclipse.team.cvs.ui", 0, Policy.bind("TagInRepositoryAction.tagProblemsMessageMultiple"), null);
        int i = 0;
        while (i < problems.length) {
            combinedStatus.merge(problems[i]);
            ++i;
        }
        return combinedStatus;
    }

    protected boolean requiresLocalSyncInfo() {
        return false;
    }

    private ICVSResource getRootParent(ICVSResource resource) throws CVSException {
        if (!resource.isManaged()) {
            return resource;
        }
        ICVSFolder parent = resource.getParent();
        if (parent == null) {
            return resource;
        }
        if (parent.getName().length() == 0) {
            return resource;
        }
        return this.getRootParent((ICVSResource)parent);
    }
}

