/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagAsVersionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.team.internal.ui.PromptingDialog;

public class TagAction
extends WorkspaceAction {
    protected static String previousTag = "";

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources;
        PromptingDialog prompt = new PromptingDialog(this.getShell(), this.getSelectedResources(), this.getPromptCondition(), Policy.bind("TagAction.uncommittedChangesTitle"));
        try {
            resources = prompt.promptForMultiple();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (resources.length == 0) {
            return;
        }
        final String[] result = new String[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resources[0].getProject());
                result[0] = TagAction.this.promptForTag(folder);
            }
        });
        if (result[0] == null) {
            return;
        }
        final RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Hashtable table = TagAction.this.getProviderMapping(resources);
                Set keySet = table.keySet();
                monitor.beginTask(null, keySet.size() * 1000);
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
                    CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
                    List list = (List)table.get(provider);
                    IResource[] providerResources = list.toArray(new IResource[list.size()]);
                    CVSTag tag = new CVSTag(result[0], 2);
                    try {
                        TagAction.this.addStatus(provider.tag(providerResources, 2, tag, (IProgressMonitor)subMonitor));
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                    try {
                        manager.addTags((ICVSResource)CVSWorkspaceRoot.getCVSFolderFor((IContainer)provider.getProject()), new CVSTag[]{tag});
                    }
                    catch (CVSException e) {
                        TagAction.this.addStatus(e.getStatus());
                    }
                }
                previousTag = result[0];
            }
        }, true, 1);
    }

    protected IStatus getStatusToDisplay(IStatus[] problems) {
        IStatus[] status = this.getAccumulatedStatus();
        int resourceCount = status.length;
        MultiStatus combinedStatus = resourceCount == 1 ? new MultiStatus("org.eclipse.team.cvs.ui", 0, Policy.bind("TagAction.tagProblemsMessage"), null) : new MultiStatus("org.eclipse.team.cvs.ui", 0, Policy.bind("TagAction.tagProblemsMessageMultiple", Integer.toString(resourceCount - problems.length), Integer.toString(problems.length)), null);
        int i = 0;
        while (i < problems.length) {
            combinedStatus.merge(problems[i]);
            ++i;
        }
        return combinedStatus;
    }

    protected String promptForTag(ICVSFolder folder) {
        TagAsVersionDialog dialog = new TagAsVersionDialog(this.getShell(), Policy.bind("TagAction.tagResources"), folder);
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getTagName();
    }

    protected IPromptCondition getPromptCondition() {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                return CVSLightweightDecorator.isDirty(resource);
            }

            public String promptMessage(IResource resource) {
                return Policy.bind("TagAction.uncommittedChanges", resource.getName());
            }
        };
    }

    protected String getErrorTitle() {
        return Policy.bind("TagAction.tagErrorTitle");
    }

    protected String getWarningTitle() {
        return Policy.bind("TagAction.tagWarningTitle");
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }
}

