/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.SynchronizeProjectsDialog;
import org.eclipse.team.internal.ccvs.ui.actions.SyncAction;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkingSet;

public class SyncAllAction
extends SyncAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    static /* synthetic */ Class class$0;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.shell = window.getShell();
    }

    protected IProject[] getSharedProjects() {
        ArrayList<IProject> selected = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)projects[i], (String)CVSProviderPlugin.getTypeId());
            if (provider != null) {
                selected.add(projects[i]);
            }
            ++i;
        }
        return selected.toArray(new IProject[selected.size()]);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSharedProjects().length > 0;
    }

    protected IResource[] getResourcesToSync() {
        return this.getSharedProjects();
    }

    protected SyncCompareInput getCompareInput(IResource[] resources) throws CVSException {
        SynchronizeProjectsDialog dialog = new SynchronizeProjectsDialog(this.getShell());
        if (dialog.open() == 1) {
            return null;
        }
        resources = this.getWorkingSetResources(resources, dialog.getWorkingSet());
        return new CVSSyncCompareInput(resources, dialog.isSyncOutgoingChanges());
    }

    private IResource[] getWorkingSetResources(IResource[] resources, IWorkingSet set) throws CVSException {
        if (set == null) {
            return resources;
        }
        HashSet<IResource> sharedResources = new HashSet<IResource>();
        IAdaptable[] adaptables = set.getElements();
        int i = 0;
        while (i < adaptables.length) {
            IResource resource;
            Object adapted;
            IAdaptable adaptable = adaptables[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapted = adaptable.getAdapter((Class)clazz)) != null && CVSWorkspaceRoot.isSharedWithCVS((IResource)(resource = (IResource)adapted))) {
                sharedResources.add(resource);
            }
            ++i;
        }
        return sharedResources.toArray(new IResource[sharedResources.size()]);
    }

    protected IResource[] getSelectedResources() {
        return new IResource[0];
    }

    protected IWorkbenchPage getTargetPage() {
        if (this.window == null) {
            return super.getTargetPage();
        }
        return this.window.getActivePage();
    }
}

