/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.team.internal.ui.sync.SyncView;
import org.eclipse.ui.IWorkbenchPage;

public class SyncAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException {
        try {
            IResource[] resources = this.getResourcesToSync();
            if (resources == null || resources.length == 0) {
                return;
            }
            SyncCompareInput input = this.getCompareInput(resources);
            if (input == null) {
                return;
            }
            SyncView view = SyncView.findViewInActivePage((IWorkbenchPage)this.getTargetPage());
            if (view != null) {
                view.showSync(input, this.getTargetPage());
            }
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected SyncCompareInput getCompareInput(IResource[] resources) throws CVSException {
        return new CVSSyncCompareInput(resources);
    }

    protected IResource[] getResourcesToSync() {
        return this.getSelectedResources();
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return super.isEnabledForCVSResource(cvsResource) || cvsResource.getParent().isCVSFolder();
    }
}

