/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ReplaceWithTagAction
extends WorkspaceAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        IResource[] cfr_ignored_0 = new IResource[1];
        final CVSTag[] tag = new CVSTag[1];
        final boolean[] recurse = new boolean[]{true};
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                IResource[] resources;
                try {
                    resources = ReplaceWithTagAction.this.checkOverwriteOfDirtyResources(ReplaceWithTagAction.this.getSelectedResources(), null);
                }
                catch (CVSException e) {
                    throw new InvocationTargetException(e);
                }
                if (resources.length == 0) {
                    return;
                }
                IProject[] projects = new IProject[resources.length];
                int i = 0;
                while (i < resources.length) {
                    projects[i] = resources[i].getProject();
                    ++i;
                }
                TagSelectionDialog dialog = new TagSelectionDialog(ReplaceWithTagAction.this.getShell(), projects, Policy.bind("ReplaceWithTagAction.message"), Policy.bind("TagSelectionDialog.Select_a_Tag_1"), 15, true, "org.eclipse.team.cvs.ui.replace_tag_selection_dialog_context");
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    return;
                }
                tag[0] = dialog.getResult();
                recurse[0] = dialog.getRecursive();
                try {
                    if (!CVSAction.checkForMixingTags(ReplaceWithTagAction.this.getShell(), resources, tag[0])) {
                        tag[0] = null;
                        return;
                    }
                }
                catch (CVSException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, false, 2);
        if (tag[0] == null) {
            return;
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        int depth = recurse[0] ? 2 : 1;
                        Hashtable table = ReplaceWithTagAction.this.getProviderMapping();
                        Set keySet = table.keySet();
                        monitor.beginTask("", keySet.size() * 1000);
                        monitor.setTaskName(Policy.bind("ReplaceWithTagAction.replacing", tag[0].getName()));
                        Iterator iterator = keySet.iterator();
                        while (iterator.hasNext()) {
                            new SubProgressMonitor(monitor, 1000);
                            CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
                            List list = (List)table.get(provider);
                            IResource[] providerResources = list.toArray(new IResource[list.size()]);
                            provider.get(providerResources, depth, tag[0], Policy.subMonitorFor(monitor, 100));
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var9_12 = null;
                monitor.done();
            }
        }, true, 1);
    }

    protected boolean equalTags(CVSTag tag1, CVSTag tag2) {
        if (tag1 == null) {
            tag1 = CVSTag.DEFAULT;
        }
        if (tag2 == null) {
            tag2 = CVSTag.DEFAULT;
        }
        return tag1.equals((Object)tag2);
    }

    protected String getErrorTitle() {
        return Policy.bind("ReplaceWithTagAction.replace");
    }
}

