/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ReplaceWithRemoteAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        monitor = Policy.monitorFor(monitor);
                        monitor.beginTask(null, 100);
                        IResource[] resources = ReplaceWithRemoteAction.this.checkOverwriteOfDirtyResources(ReplaceWithRemoteAction.this.getSelectedResources(), (IProgressMonitor)new InfiniteSubProgressMonitor(monitor, 20));
                        if (resources.length > 0) {
                            ReplaceWithRemoteAction.this.performReplace(resources, Policy.subMonitorFor(monitor, 80));
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_6 = null;
                monitor.done();
            }
        }, true, 1);
    }

    private void performReplace(IResource[] resources, IProgressMonitor monitor) throws TeamException {
        try {
            Hashtable table = this.getProviderMapping(resources);
            Set keySet = table.keySet();
            monitor.beginTask(null, keySet.size() * 10);
            monitor.setTaskName(Policy.bind("ReplaceWithRemoteAction.replacing"));
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
                CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
                List list = (List)table.get(provider);
                IResource[] providerResources = list.toArray(new IResource[list.size()]);
                provider.get(providerResources, 2, (IProgressMonitor)subMonitor);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        Object var10_12 = null;
        monitor.done();
    }

    protected IPromptCondition getPromptCondition(IResource[] dirtyResources) {
        return CVSAction.getOverwriteLocalChangesPrompt(dirtyResources);
    }

    protected String getErrorTitle() {
        return Policy.bind("ReplaceWithRemoteAction.problemMessage");
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        if (super.isEnabledForCVSResource(cvsResource)) {
            String tag;
            String revision;
            ResourceSyncInfo info;
            return cvsResource.isFolder() || (info = cvsResource.getSyncInfo()) == null || info.getTag() == null || !(revision = info.getRevision()).equals(tag = info.getTag().getName());
        }
        return false;
    }

    protected void setActionEnablement(IAction action) {
        super.setActionEnablement(action);
        action.setText(this.calculateActionTagValue());
    }
}

