/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.ui.CVSCompareEditorInput;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;
import org.eclipse.team.internal.ccvs.ui.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.ui.IWorkbenchPage;

public class CompareRemoteWithTagAction
extends CVSAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSRemoteResource[] editions = this.getSelectedRemoteResources();
        if (editions.length == 0) {
            return;
        }
        final ICVSRemoteResource resource = editions[0];
        final ResourceEditionNode[] input = new ResourceEditionNode[2];
        final CVSTag[] tag = new CVSTag[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                ICVSFolder folder = resource instanceof ICVSRemoteFolder ? (ICVSFolder)resource : resource.getParent();
                tag[0] = TagSelectionDialog.getTagToCompareWith(CompareRemoteWithTagAction.this.getShell(), new ICVSFolder[]{folder});
            }
        }, false, 2);
        if (tag[0] == null) {
            return;
        }
        final ICVSRemoteResource[] remote = new ICVSRemoteResource[1];
        if (resource.isFolder()) {
            remote[0] = resource.forTag(tag[0]);
        } else {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ICVSRepositoryLocation location = resource.getRepository();
                        remote[0] = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)((CVSRepositoryLocation)location), (ICVSFile)((ICVSFile)resource), (CVSTag)tag[0], (IProgressMonitor)monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, false, 1);
        }
        input[0] = new ResourceEditionNode(resource);
        input[1] = new ResourceEditionNode(remote[0]);
        if (input[0] == null || input[1] == null) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)new CVSCompareEditorInput(input[0], input[1]), (IWorkbenchPage)CompareRemoteWithTagAction.this.getTargetPage());
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        ICVSRemoteResource[] resources = this.getSelectedRemoteResources();
        return resources.length == 1;
    }
}

